/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

class ArchivedTaskManagerLocationMatcher
implements Predicate<ExceptionHistoryEntry.ArchivedTaskManagerLocation> {
    private final ExceptionHistoryEntry.ArchivedTaskManagerLocation expectedLocation;

    public static Predicate<ExceptionHistoryEntry.ArchivedTaskManagerLocation> isArchivedTaskManagerLocation(TaskManagerLocation actualLocation) {
        return new ArchivedTaskManagerLocationMatcher(actualLocation);
    }

    ArchivedTaskManagerLocationMatcher(TaskManagerLocation expectedLocation) {
        this(ExceptionHistoryEntry.ArchivedTaskManagerLocation.fromTaskManagerLocation((TaskManagerLocation)expectedLocation));
    }

    ArchivedTaskManagerLocationMatcher(ExceptionHistoryEntry.ArchivedTaskManagerLocation expectedLocation) {
        this.expectedLocation = expectedLocation;
    }

    @Override
    public boolean test(ExceptionHistoryEntry.ArchivedTaskManagerLocation actual) {
        if (actual == null) {
            return this.expectedLocation == null;
        }
        if (this.expectedLocation == null) {
            return false;
        }
        boolean match = true;
        if (!Objects.equals(actual.getAddress(), this.expectedLocation.getAddress())) {
            match = false;
        }
        if (!Objects.equals(actual.getFQDNHostname(), this.expectedLocation.getFQDNHostname())) {
            match = false;
        }
        if (!Objects.equals(actual.getHostname(), this.expectedLocation.getHostname())) {
            match = false;
        }
        if (!Objects.equals(actual.getResourceID(), this.expectedLocation.getResourceID())) {
            match = false;
        }
        if (!Objects.equals(actual.getPort(), this.expectedLocation.getPort())) {
            match = false;
        }
        return match;
    }
}

