/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroupImpl;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.AbstractSlotSharingStrategyTest;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.TaskBalancedPreferredSlotSharingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.shaded.guava33.com.google.common.collect.Sets;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class TaskBalancedPreferredSlotSharingStrategyTest
extends AbstractSlotSharingStrategyTest {
    TaskBalancedPreferredSlotSharingStrategyTest() {
    }

    @Override
    protected SlotSharingStrategy getSlotSharingStrategy(SchedulingTopology topology, Set<SlotSharingGroup> slotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
        return new TaskBalancedPreferredSlotSharingStrategy(topology, slotSharingGroups, coLocationGroups);
    }

    @Test
    void testVerticesInDifferentSlotSharingGroups() {
        ArrayList<Tuple2<JobVertexID, List<TestingSchedulingExecutionVertex>>> jobVertexInfos = new ArrayList<Tuple2<JobVertexID, List<TestingSchedulingExecutionVertex>>>();
        ArrayList testingJobVertexInfos = Lists.newArrayList((Object[])new AbstractSlotSharingStrategyTest.TestingJobVertexInfo[]{new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(1, this.slotSharingGroup1, null), new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(2, this.slotSharingGroup1, null), new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(3, this.slotSharingGroup1, null), new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(1, this.slotSharingGroup2, null), new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(2, this.slotSharingGroup2, null), new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(2, this.slotSharingGroup2, null)});
        this.renderTopology(this.topology, testingJobVertexInfos, jobVertexInfos);
        SlotSharingStrategy strategy = this.getSlotSharingStrategy(this.topology, Sets.newHashSet((Object[])new SlotSharingGroup[]{this.slotSharingGroup1, this.slotSharingGroup2}), Sets.newHashSet());
        Assertions.assertThat((Collection)strategy.getExecutionSlotSharingGroups()).hasSize(5);
        this.checkBalanceAtSlotsLevelWithoutCoLocation(strategy);
        List executionVertices4 = (List)((Tuple2)jobVertexInfos.get((int)4)).f1;
        List executionVertices5 = (List)((Tuple2)jobVertexInfos.get((int)5)).f1;
        Assertions.assertThat((List)executionVertices4).hasSameSizeAs((Iterable)executionVertices5);
        for (int i = 0; i < executionVertices4.size(); ++i) {
            TestingSchedulingExecutionVertex executionVertex4 = (TestingSchedulingExecutionVertex)executionVertices4.get(i);
            Assertions.assertThat((Object)strategy.getExecutionSlotSharingGroup(executionVertex4.getId())).isEqualTo((Object)strategy.getExecutionSlotSharingGroup(((TestingSchedulingExecutionVertex)executionVertices5.get(i)).getId()));
        }
    }

    private void checkBalanceAtSlotsLevelWithoutCoLocation(SlotSharingStrategy strategy) {
        strategy.getExecutionSlotSharingGroups().stream().collect(Collectors.groupingBy(ExecutionSlotSharingGroup::getSlotSharingGroup)).forEach((slotSharingGroup, executionSlotSharingGroups) -> {
            Optional<Integer> max = executionSlotSharingGroups.stream().map(executionSlotSharingGroup -> executionSlotSharingGroup.getExecutionVertexIds().size()).max(Comparator.comparing(i -> i));
            Optional<Integer> min = executionSlotSharingGroups.stream().map(executionSlotSharingGroup -> executionSlotSharingGroup.getExecutionVertexIds().size()).min(Comparator.comparing(i -> i));
            Assertions.assertThat((Integer)max.get()).isCloseTo(min.get(), Offset.offset((Number)1));
        });
    }

    @Test
    void testCoLocationConstraintIsRespected() {
        int i;
        ArrayList<Tuple2<JobVertexID, List<TestingSchedulingExecutionVertex>>> jobVertexInfos = new ArrayList<Tuple2<JobVertexID, List<TestingSchedulingExecutionVertex>>>();
        CoLocationGroupImpl coLocationGroup1 = new CoLocationGroupImpl(new JobVertex[0]);
        CoLocationGroupImpl coLocationGroup2 = new CoLocationGroupImpl(new JobVertex[0]);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv0 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(1, this.slotSharingGroup, null);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv1 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(2, this.slotSharingGroup, (CoLocationGroup)coLocationGroup1);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv2 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(2, this.slotSharingGroup, (CoLocationGroup)coLocationGroup1);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv3 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(1, this.slotSharingGroup, null);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv4 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(4, this.slotSharingGroup, (CoLocationGroup)coLocationGroup1);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv5 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(4, this.slotSharingGroup, (CoLocationGroup)coLocationGroup1);
        AbstractSlotSharingStrategyTest.TestingJobVertexInfo tJv6 = new AbstractSlotSharingStrategyTest.TestingJobVertexInfo(3, this.slotSharingGroup, (CoLocationGroup)coLocationGroup2);
        ArrayList mockedJobVertices = Lists.newArrayList((Object[])new AbstractSlotSharingStrategyTest.TestingJobVertexInfo[]{tJv0, tJv1, tJv2, tJv3, tJv4, tJv5, tJv6});
        this.renderTopology(this.topology, mockedJobVertices, jobVertexInfos);
        SlotSharingStrategy strategy = this.getSlotSharingStrategy(this.topology, Sets.newHashSet((Object[])new SlotSharingGroup[]{this.slotSharingGroup}), Sets.newHashSet((Object[])new CoLocationGroup[]{coLocationGroup1, coLocationGroup2}));
        List jv0Vertices = (List)((Tuple2)jobVertexInfos.get((int)0)).f1;
        List jv1Vertices = (List)((Tuple2)jobVertexInfos.get((int)1)).f1;
        List jv2Vertices = (List)((Tuple2)jobVertexInfos.get((int)2)).f1;
        List jv4Vertices = (List)((Tuple2)jobVertexInfos.get((int)4)).f1;
        List jv5Vertices = (List)((Tuple2)jobVertexInfos.get((int)5)).f1;
        List jv6Vertices = (List)((Tuple2)jobVertexInfos.get((int)6)).f1;
        for (i = 0; i < jv1Vertices.size(); ++i) {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.getTargetGroup(strategy, jv1Vertices, i)).isEqualTo((Object)this.getTargetGroup(strategy, jv2Vertices, i))).isEqualTo((Object)this.getTargetGroup(strategy, jv4Vertices, i))).isEqualTo((Object)this.getTargetGroup(strategy, jv5Vertices, i));
        }
        for (i = 0; i < jv4Vertices.size(); ++i) {
            Assertions.assertThat((Object)this.getTargetGroup(strategy, jv4Vertices, i)).isEqualTo((Object)this.getTargetGroup(strategy, jv5Vertices, i));
        }
        ((ObjectAssert)Assertions.assertThat((Object)this.getTargetGroup(strategy, jv4Vertices, 2)).isNotEqualTo((Object)this.getTargetGroup(strategy, jv1Vertices, 0))).isNotEqualTo((Object)this.getTargetGroup(strategy, jv1Vertices, 1));
        ((ObjectAssert)Assertions.assertThat((Object)this.getTargetGroup(strategy, jv4Vertices, 3)).isNotEqualTo((Object)this.getTargetGroup(strategy, jv1Vertices, 0))).isNotEqualTo((Object)this.getTargetGroup(strategy, jv1Vertices, 1));
        Assertions.assertThat((Object)this.getTargetGroup(strategy, jv6Vertices, 0)).isEqualTo((Object)this.getTargetGroup(strategy, jv0Vertices, 0));
        Assertions.assertThat((Object)this.getTargetGroup(strategy, jv6Vertices, 1)).isEqualTo((Object)this.getTargetGroup(strategy, jv4Vertices, 3));
        Assertions.assertThat((Object)this.getTargetGroup(strategy, jv6Vertices, 2)).isEqualTo((Object)this.getTargetGroup(strategy, jv4Vertices, 0));
    }

    private ExecutionSlotSharingGroup getTargetGroup(SlotSharingStrategy strategy, List<TestingSchedulingExecutionVertex> jvVertices, int index) {
        return strategy.getExecutionSlotSharingGroup(jvVertices.get(index).getId());
    }
}

