/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerRequestUtils;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.MessagePathParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HandlerRequestUtilsTest {
    HandlerRequestUtilsTest() {
    }

    @Test
    void testGetQueryParameter() throws Exception {
        Boolean queryParameter = (Boolean)HandlerRequestUtils.getQueryParameter((HandlerRequest)HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap("key", Collections.singletonList("true")), Collections.emptyList()), TestBooleanQueryParameter.class);
        Assertions.assertThat((Boolean)queryParameter).isTrue();
    }

    @Test
    void testGetQueryParameterRepeated() throws Exception {
        try {
            HandlerRequestUtils.getQueryParameter((HandlerRequest)HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap("key", Arrays.asList("true", "false")), Collections.emptyList()), TestBooleanQueryParameter.class);
        }
        catch (RestHandlerException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Expected only one value"});
        }
    }

    @Test
    void testGetQueryParameterDefaultValue() throws Exception {
        Boolean allowNonRestoredState = (Boolean)HandlerRequestUtils.getQueryParameter((HandlerRequest)HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TestMessageParameters(), Collections.emptyMap(), Collections.singletonMap("key", Collections.emptyList()), Collections.emptyList()), TestBooleanQueryParameter.class, (Object)true);
        Assertions.assertThat((Boolean)allowNonRestoredState).isTrue();
    }

    private static class TestBooleanQueryParameter
    extends MessageQueryParameter<Boolean> {
        private TestBooleanQueryParameter() {
            super("key", MessageParameter.MessageParameterRequisiteness.OPTIONAL);
        }

        public Boolean convertStringToValue(String value) {
            return Boolean.parseBoolean(value);
        }

        public String convertValueToString(Boolean value) {
            return value.toString();
        }

        public String getDescription() {
            return "boolean query parameter";
        }
    }

    private static class TestMessageParameters
    extends MessageParameters {
        private final TestBooleanQueryParameter testBooleanQueryParameter = new TestBooleanQueryParameter();

        private TestMessageParameters() {
        }

        public Collection<MessagePathParameter<?>> getPathParameters() {
            return Collections.emptyList();
        }

        public Collection<MessageQueryParameter<?>> getQueryParameters() {
            return Collections.singletonList(this.testBooleanQueryParameter);
        }
    }
}

