/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.math.BigDecimal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlotManagerConfigurationTest {
    SlotManagerConfigurationTest() {
    }

    @Test
    void testComputeMinTotalCpu() throws Exception {
        Configuration configuration = new Configuration();
        int minSlotNum = 9;
        int numSlots = 3;
        double cpuCores = 10.0;
        configuration.set(ResourceManagerOptions.MIN_SLOT_NUM, (Object)9);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).setCpuCores(10.0).build());
        Assertions.assertThat((double)slotManagerConfiguration.getMinTotalCpu().getValue().doubleValue()).isEqualTo(30.0);
    }

    @Test
    void testComputeMaxTotalCpu() throws Exception {
        Configuration configuration = new Configuration();
        int maxSlotNum = 9;
        int numSlots = 3;
        double cpuCores = 10.0;
        configuration.set(ResourceManagerOptions.MAX_SLOT_NUM, (Object)9);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).setCpuCores(10.0).build());
        Assertions.assertThat((double)slotManagerConfiguration.getMaxTotalCpu().getValue().doubleValue()).isEqualTo(30.0);
    }

    @Test
    void testComputeMinTotalMemory() throws Exception {
        Configuration configuration = new Configuration();
        int minSlotNum = 1000;
        int numSlots = 10;
        int totalTaskManagerMB = MemorySize.parse((String)"1", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.TERA_BYTES).getMebiBytes();
        configuration.set(ResourceManagerOptions.MIN_SLOT_NUM, (Object)1000);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(10).setTaskHeapMemoryMB(totalTaskManagerMB).build());
        Assertions.assertThat((long)slotManagerConfiguration.getMinTotalMem().getBytes()).isEqualTo(BigDecimal.valueOf(MemorySize.ofMebiBytes((long)totalTaskManagerMB).getBytes()).multiply(BigDecimal.valueOf(1000L)).divide(BigDecimal.valueOf(10L)).longValue());
    }

    @Test
    void testComputeMaxTotalMemory() throws Exception {
        Configuration configuration = new Configuration();
        int maxSlotNum = 1000000;
        int numSlots = 10;
        int totalTaskManagerMB = MemorySize.parse((String)"1", (MemorySize.MemoryUnit)MemorySize.MemoryUnit.TERA_BYTES).getMebiBytes();
        configuration.set(ResourceManagerOptions.MAX_SLOT_NUM, (Object)1000000);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(10).setTaskHeapMemoryMB(totalTaskManagerMB).build());
        Assertions.assertThat((long)slotManagerConfiguration.getMaxTotalMem().getBytes()).isEqualTo(BigDecimal.valueOf(MemorySize.ofMebiBytes((long)totalTaskManagerMB).getBytes()).multiply(BigDecimal.valueOf(1000000L)).divide(BigDecimal.valueOf(10L)).longValue());
    }

    @Test
    void testComputeMinMaxSlotNumIsValid() throws Exception {
        Configuration configuration = new Configuration();
        int minSlotNum = 9;
        int maxSlotNum = 12;
        int numSlots = 3;
        double cpuCores = 10.0;
        configuration.set(ResourceManagerOptions.MIN_SLOT_NUM, (Object)9);
        configuration.set(ResourceManagerOptions.MAX_SLOT_NUM, (Object)12);
        SlotManagerConfiguration slotManagerConfiguration = SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).setCpuCores(10.0).build());
        Assertions.assertThat((double)slotManagerConfiguration.getMinTotalCpu().getValue().doubleValue()).isEqualTo(30.0);
        Assertions.assertThat((double)slotManagerConfiguration.getMaxTotalCpu().getValue().doubleValue()).isEqualTo(40.0);
    }

    @Test
    void testComputeMinMaxSlotNumIsInvalid() {
        Configuration configuration = new Configuration();
        int minSlotNum = 10;
        int maxSlotNum = 11;
        int numSlots = 3;
        configuration.set(ResourceManagerOptions.MIN_SLOT_NUM, (Object)10);
        configuration.set(ResourceManagerOptions.MAX_SLOT_NUM, (Object)11);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).build()));
    }

    @Test
    void testComputeMinMaxCpuIsInvalid() {
        Configuration configuration = new Configuration();
        double minTotalCpu = 10.0;
        double maxTotalCpu = 11.0;
        int numSlots = 3;
        double cpuCores = 3.0;
        configuration.set(ResourceManagerOptions.MIN_TOTAL_CPU, (Object)10.0);
        configuration.set(ResourceManagerOptions.MAX_TOTAL_CPU, (Object)11.0);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).setCpuCores(3.0).build()));
    }

    @Test
    void testComputeMinMaxMemoryIsInvalid() {
        Configuration configuration = new Configuration();
        MemorySize minMemorySize = MemorySize.ofMebiBytes((long)500L);
        MemorySize maxMemorySize = MemorySize.ofMebiBytes((long)700L);
        int numSlots = 3;
        configuration.set(ResourceManagerOptions.MIN_TOTAL_MEM, (Object)minMemorySize);
        configuration.set(ResourceManagerOptions.MAX_TOTAL_MEM, (Object)maxMemorySize);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> SlotManagerConfiguration.fromConfiguration((Configuration)configuration, (WorkerResourceSpec)new WorkerResourceSpec.Builder().setNumSlots(3).setTaskHeapMemoryMB(100).setManagedMemoryMB(100).setNetworkMemoryMB(100).setTaskOffHeapMemoryMB(100).build()));
    }
}

