/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RuntimePairComparatorFactory;
import org.apache.flink.runtime.operators.AbstractOuterJoinDriver;
import org.apache.flink.runtime.operators.AbstractOuterJoinTaskExternalITCase;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.RightOuterJoinDriver;
import org.apache.flink.runtime.operators.testutils.UniformIntTupleGenerator;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;

class RightOuterJoinTaskExternalITCase
extends AbstractOuterJoinTaskExternalITCase {
    private final double hash_frac = 4194304.0 / (double)this.getMemoryManager().getMemorySize();

    RightOuterJoinTaskExternalITCase(ExecutionConfig config) {
        super(config);
    }

    @Override
    protected int calculateExpectedCount(int keyCnt1, int valCnt1, int keyCnt2, int valCnt2) {
        return valCnt1 * valCnt2 * Math.min(keyCnt1, keyCnt2) + (keyCnt2 > keyCnt1 ? (keyCnt2 - keyCnt1) * valCnt2 : 0);
    }

    @Override
    protected AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> getOuterJoinDriver() {
        return new RightOuterJoinDriver();
    }

    @Override
    protected DriverStrategy getSortStrategy() {
        return DriverStrategy.RIGHT_OUTER_MERGE;
    }

    @TestTemplate
    void testExternalHashRightOuterJoinTask() throws Exception {
        int keyCnt1 = 32768;
        int valCnt1 = 8;
        int keyCnt2 = 65536;
        int valCnt2 = 8;
        int expCnt = this.calculateExpectedCount(32768, 8, 65536, 8);
        this.setOutput(this.output);
        this.addDriverComparator(this.comparator1);
        this.addDriverComparator(this.comparator2);
        this.getTaskConfig().setDriverPairComparator((TypePairComparatorFactory)new RuntimePairComparatorFactory());
        this.getTaskConfig().setDriverStrategy(DriverStrategy.RIGHT_HYBRIDHASH_BUILD_FIRST);
        this.getTaskConfig().setRelativeMemoryDriver(this.hash_frac);
        AbstractOuterJoinDriver<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> testTask = this.getOuterJoinDriver();
        this.addInputSorted(new UniformIntTupleGenerator(32768, 8, false), this.serializer, this.comparator1.duplicate());
        this.addInputSorted(new UniformIntTupleGenerator(65536, 8, false), this.serializer, this.comparator2.duplicate());
        this.testDriver((Driver)testTask, AbstractOuterJoinTaskExternalITCase.MockJoinStub.class);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.output.getNumberOfRecords()).withFailMessage("Wrong result set size.", new Object[0])).isEqualTo(expCnt);
    }
}

