/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkWithTimestamp;
import org.apache.flink.runtime.jobmaster.slotpool.TestingPhysicalSlotRequestBulkBuilder;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PhysicalSlotRequestBulkWithTimestampTest {
    private final ManualClock clock = new ManualClock();

    PhysicalSlotRequestBulkWithTimestampTest() {
    }

    @Test
    void testMarkBulkUnfulfillable() {
        PhysicalSlotRequestBulkWithTimestamp bulk = PhysicalSlotRequestBulkWithTimestampTest.createPhysicalSlotRequestBulkWithTimestamp();
        this.clock.advanceTime(456L, TimeUnit.MILLISECONDS);
        bulk.markUnfulfillable(this.clock.relativeTimeMillis());
        Assertions.assertThat((long)bulk.getUnfulfillableSince()).isEqualTo(this.clock.relativeTimeMillis());
    }

    @Test
    void testUnfulfillableTimestampWillNotBeOverriddenByFollowingUnfulfillableTimestamp() {
        PhysicalSlotRequestBulkWithTimestamp bulk = PhysicalSlotRequestBulkWithTimestampTest.createPhysicalSlotRequestBulkWithTimestamp();
        long unfulfillableSince = this.clock.relativeTimeMillis();
        bulk.markUnfulfillable(unfulfillableSince);
        this.clock.advanceTime(456L, TimeUnit.MILLISECONDS);
        bulk.markUnfulfillable(this.clock.relativeTimeMillis());
        Assertions.assertThat((long)bulk.getUnfulfillableSince()).isEqualTo(unfulfillableSince);
    }

    private static PhysicalSlotRequestBulkWithTimestamp createPhysicalSlotRequestBulkWithTimestamp() {
        return TestingPhysicalSlotRequestBulkBuilder.newBuilder().buildPhysicalSlotRequestBulkWithTimestamp();
    }
}

