/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.TestingFileDataIndexRegion;
import org.assertj.core.api.Assertions;

public class HybridShuffleTestUtils {
    public static final int MEMORY_SEGMENT_SIZE = 128;

    public static TestingFileDataIndexRegion createSingleTestRegion(int firstBufferIndex, long firstBufferOffset, int numBuffersPerRegion) {
        return new TestingFileDataIndexRegion.Builder().setGetSizeSupplier(() -> 16).setContainBufferFunction(bufferIndex -> TestingFileDataIndexRegion.getContainBufferFunction(bufferIndex, firstBufferIndex, numBuffersPerRegion)).setGetFirstBufferIndexSupplier(() -> firstBufferIndex).setGetRegionFileOffsetSupplier(() -> firstBufferOffset).setGetNumBuffersSupplier(() -> numBuffersPerRegion).build();
    }

    public static List<TestingFileDataIndexRegion> createTestRegions(int firstBufferIndex, long firstBufferOffset, int numBuffersPerRegion, int numRegions) {
        ArrayList<TestingFileDataIndexRegion> regions = new ArrayList<TestingFileDataIndexRegion>();
        int bufferIndex = firstBufferIndex;
        long bufferOffset = firstBufferOffset;
        int numRegionSize = 16;
        for (int i = 0; i < numRegions; ++i) {
            int currentBufferIndex = bufferIndex;
            long currentBufferOffset = bufferOffset;
            regions.add(new TestingFileDataIndexRegion.Builder().setGetSizeSupplier(() -> numRegionSize).setGetFirstBufferIndexSupplier(() -> currentBufferIndex).setGetRegionFileOffsetSupplier(() -> currentBufferOffset).setGetNumBuffersSupplier(() -> numBuffersPerRegion).setContainBufferFunction(index -> TestingFileDataIndexRegion.getContainBufferFunction(index, firstBufferIndex, numBuffersPerRegion)).build());
            bufferIndex += numBuffersPerRegion;
            bufferOffset += bufferOffset;
        }
        return regions;
    }

    public static void assertRegionEquals(FileDataIndexRegionHelper.Region expected, FileDataIndexRegionHelper.Region region) {
        Assertions.assertThat((int)region.getFirstBufferIndex()).isEqualTo(expected.getFirstBufferIndex());
        Assertions.assertThat((long)region.getRegionStartOffset()).isEqualTo(expected.getRegionStartOffset());
        Assertions.assertThat((int)region.getNumBuffers()).isEqualTo(expected.getNumBuffers());
    }
}

