/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriterWithCallback;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileSegmentReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileSegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class IOManagerTest {
    IOManagerTest() {
    }

    @Test
    void channelEnumerator(@TempDir File tempPath) throws Exception {
        String[] tempDirs = new String[]{new File(tempPath, "a").getAbsolutePath(), new File(tempPath, "b").getAbsolutePath(), new File(tempPath, "c").getAbsolutePath(), new File(tempPath, "d").getAbsolutePath(), new File(tempPath, "e").getAbsolutePath()};
        int[] counters = new int[tempDirs.length];
        try (TestIOManager ioMan = new TestIOManager(tempDirs);){
            FileIOChannel.Enumerator enumerator = ioMan.createChannelEnumerator();
            for (int i = 0; i < 3 * tempDirs.length; ++i) {
                FileIOChannel.ID id = enumerator.next();
                File pathFile = id.getPathFile();
                Files.createFile(pathFile.toPath(), new FileAttribute[0]);
                ((AbstractFileAssert)Assertions.assertThat((File)pathFile).withFailMessage("Channel IDs must name an absolute path.", new Object[0])).isAbsolute();
                ((AbstractFileAssert)Assertions.assertThat((File)pathFile).withFailMessage("Channel IDs must name a file, not a directory.", new Object[0])).isFile();
                ((AbstractFileAssert)Assertions.assertThat((File)pathFile.getParentFile().getParentFile().getParentFile()).withFailMessage("Path is not in the temp directory.", new Object[0])).isEqualTo((Object)tempPath);
                for (int k = 0; k < tempDirs.length; ++k) {
                    if (!pathFile.getParentFile().getParent().equals(tempDirs[k])) continue;
                    int n = k;
                    counters[n] = counters[n] + 1;
                }
            }
            for (int k = 0; k < tempDirs.length; ++k) {
                Assertions.assertThat((int)counters[k]).isEqualTo(3);
            }
        }
    }

    private static class TestIOManager
    extends IOManager {
        protected TestIOManager(String[] paths) {
            super(paths, (ExecutorService)Executors.newSingleThreadScheduledExecutor());
        }

        public BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID, LinkedBlockingQueue<MemorySegment> returnQueue) {
            throw new UnsupportedOperationException();
        }

        public BlockChannelWriterWithCallback<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID, RequestDoneCallback<MemorySegment> callback) {
            throw new UnsupportedOperationException();
        }

        public BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID channelID, LinkedBlockingQueue<MemorySegment> returnQueue) {
            throw new UnsupportedOperationException();
        }

        public BufferFileWriter createBufferFileWriter(FileIOChannel.ID channelID) {
            throw new UnsupportedOperationException();
        }

        public BufferFileReader createBufferFileReader(FileIOChannel.ID channelID, RequestDoneCallback<Buffer> callback) {
            throw new UnsupportedOperationException();
        }

        public BufferFileSegmentReader createBufferFileSegmentReader(FileIOChannel.ID channelID, RequestDoneCallback<FileSegment> callback) {
            throw new UnsupportedOperationException();
        }

        public BulkBlockChannelReader createBulkBlockChannelReader(FileIOChannel.ID channelID, List<MemorySegment> targetSegments, int numBlocks) {
            throw new UnsupportedOperationException();
        }
    }
}

