/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.function.TriFunction;

public final class TestingCompletedCheckpointStore
implements CompletedCheckpointStore {
    private final TriFunction<CompletedCheckpoint, CheckpointsCleaner, Runnable, CompletedCheckpoint> addCheckpointAndSubsumeOldestOneFunction;
    private final BiConsumer<JobStatus, CheckpointsCleaner> shutdownConsumer;
    private final Supplier<List<CompletedCheckpoint>> getAllCheckpointsSupplier;
    private final Supplier<Integer> getNumberOfRetainedCheckpointsSuppler;
    private final Supplier<Integer> getMaxNumberOfRetainedCheckpointsSupplier;
    private final Supplier<Boolean> requiresExternalizedCheckpointsSupplier;
    private final Supplier<SharedStateRegistry> getSharedStateRegistrySupplier;

    public static TestingCompletedCheckpointStore createStoreWithShutdownCheckAndNoCompletedCheckpoints(CompletableFuture<JobStatus> shutdownFuture) {
        return TestingCompletedCheckpointStore.builder().withShutdownConsumer((jobStatus, ignoredCheckpointsCleaner) -> shutdownFuture.complete((JobStatus)jobStatus)).withGetAllCheckpointsSupplier(Collections::emptyList).build();
    }

    private TestingCompletedCheckpointStore(TriFunction<CompletedCheckpoint, CheckpointsCleaner, Runnable, CompletedCheckpoint> addCheckpointAndSubsumeOldestOneFunction, BiConsumer<JobStatus, CheckpointsCleaner> shutdownConsumer, Supplier<List<CompletedCheckpoint>> getAllCheckpointsSupplier, Supplier<Integer> getNumberOfRetainedCheckpointsSuppler, Supplier<Integer> getMaxNumberOfRetainedCheckpointsSupplier, Supplier<Boolean> requiresExternalizedCheckpointsSupplier, Supplier<SharedStateRegistry> getSharedStateRegistrySupplier) {
        this.addCheckpointAndSubsumeOldestOneFunction = addCheckpointAndSubsumeOldestOneFunction;
        this.shutdownConsumer = shutdownConsumer;
        this.getAllCheckpointsSupplier = getAllCheckpointsSupplier;
        this.getNumberOfRetainedCheckpointsSuppler = getNumberOfRetainedCheckpointsSuppler;
        this.getMaxNumberOfRetainedCheckpointsSupplier = getMaxNumberOfRetainedCheckpointsSupplier;
        this.requiresExternalizedCheckpointsSupplier = requiresExternalizedCheckpointsSupplier;
        this.getSharedStateRegistrySupplier = getSharedStateRegistrySupplier;
    }

    public CompletedCheckpoint addCheckpointAndSubsumeOldestOne(CompletedCheckpoint checkpoint, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) {
        return (CompletedCheckpoint)this.addCheckpointAndSubsumeOldestOneFunction.apply((Object)checkpoint, (Object)checkpointsCleaner, (Object)postCleanup);
    }

    public void shutdown(JobStatus jobStatus, CheckpointsCleaner checkpointsCleaner) {
        this.shutdownConsumer.accept(jobStatus, checkpointsCleaner);
    }

    public List<CompletedCheckpoint> getAllCheckpoints() {
        return this.getAllCheckpointsSupplier.get();
    }

    public int getNumberOfRetainedCheckpoints() {
        return this.getNumberOfRetainedCheckpointsSuppler.get();
    }

    public int getMaxNumberOfRetainedCheckpoints() {
        return this.getMaxNumberOfRetainedCheckpointsSupplier.get();
    }

    public boolean requiresExternalizedCheckpoints() {
        return this.requiresExternalizedCheckpointsSupplier.get();
    }

    public SharedStateRegistry getSharedStateRegistry() {
        return this.getSharedStateRegistrySupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TriFunction<CompletedCheckpoint, CheckpointsCleaner, Runnable, CompletedCheckpoint> addCheckpointAndSubsumeOldestOneFunction = (ignoredCompletedCheckpoint, ignoredCheckpointsCleaner, ignoredPostCleanup) -> {
            throw new UnsupportedOperationException("addCheckpointAndSubsumeOldestOne is not implemented.");
        };
        private BiConsumer<JobStatus, CheckpointsCleaner> shutdownConsumer = (ignoredJobStatus, ignoredCheckpointsCleaner) -> {
            throw new UnsupportedOperationException("shutdown is not implemented.");
        };
        private Supplier<List<CompletedCheckpoint>> getAllCheckpointsSupplier = () -> {
            throw new UnsupportedOperationException("getAllCheckpoints is not implemented.");
        };
        private Supplier<Integer> getNumberOfRetainedCheckpointsSuppler = () -> {
            throw new UnsupportedOperationException("getNumberOfRetainedCheckpointsis not implemented.");
        };
        private Supplier<Integer> getMaxNumberOfRetainedCheckpointsSupplier = () -> {
            throw new UnsupportedOperationException("getMaxNumberOfRetainedCheckpoints is not implemented.");
        };
        private Supplier<Boolean> requiresExternalizedCheckpointsSupplier = () -> {
            throw new UnsupportedOperationException("requiresExternalizedCheckpoints is not implemented.");
        };
        private Supplier<SharedStateRegistry> getSharedStateRegistrySupplier = () -> {
            throw new UnsupportedOperationException("getSharedStateRegistry is not implemented.");
        };

        public Builder withAddCheckpointAndSubsumeOldestOneFunction(TriFunction<CompletedCheckpoint, CheckpointsCleaner, Runnable, CompletedCheckpoint> addCheckpointAndSubsumeOldestOneFunction) {
            this.addCheckpointAndSubsumeOldestOneFunction = addCheckpointAndSubsumeOldestOneFunction;
            return this;
        }

        public Builder withShutdownConsumer(BiConsumer<JobStatus, CheckpointsCleaner> shutdownConsumer) {
            this.shutdownConsumer = shutdownConsumer;
            return this;
        }

        public Builder withGetAllCheckpointsSupplier(Supplier<List<CompletedCheckpoint>> getAllCheckpointsSupplier) {
            this.getAllCheckpointsSupplier = getAllCheckpointsSupplier;
            return this;
        }

        public Builder withGetNumberOfRetainedCheckpointsSupplier(Supplier<Integer> getNumberOfRetainedCheckpointsSuppler) {
            this.getNumberOfRetainedCheckpointsSuppler = getNumberOfRetainedCheckpointsSuppler;
            return this;
        }

        public Builder withGetMaxNumberOfRetainedCheckpointsSupplier(Supplier<Integer> getMaxNumberOfRetainedCheckpoints) {
            this.getMaxNumberOfRetainedCheckpointsSupplier = getMaxNumberOfRetainedCheckpoints;
            return this;
        }

        public Builder withRequiresExternalizedCheckpointsSupplier(Supplier<Boolean> requiresExternalizedCheckpointsSupplier) {
            this.requiresExternalizedCheckpointsSupplier = requiresExternalizedCheckpointsSupplier;
            return this;
        }

        public Builder withGetSharedStateRegistrySupplier(Supplier<SharedStateRegistry> getSharedStateRegistrySupplier) {
            this.getSharedStateRegistrySupplier = getSharedStateRegistrySupplier;
            return this;
        }

        public TestingCompletedCheckpointStore build() {
            return new TestingCompletedCheckpointStore(this.addCheckpointAndSubsumeOldestOneFunction, this.shutdownConsumer, this.getAllCheckpointsSupplier, this.getNumberOfRetainedCheckpointsSuppler, this.getMaxNumberOfRetainedCheckpointsSupplier, this.requiresExternalizedCheckpointsSupplier, this.getSharedStateRegistrySupplier);
        }
    }
}

