/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.blob.BlobCachePutTest;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobCacheSizeTracker;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.TestingBlobHelpers;
import org.apache.flink.runtime.blob.TestingBlobUtils;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BlobCacheCleanupTest {
    @TempDir
    private Path tempDir;
    private final Random rnd = new Random();

    BlobCacheCleanupTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testPermanentBlobCleanup() throws IOException, InterruptedException {
        BlobServer server;
        JobID jobId;
        block7: {
            jobId = new JobID();
            ArrayList<PermanentBlobKey> keys = new ArrayList<PermanentBlobKey>();
            server = null;
            PermanentBlobCache cache = null;
            byte[] buf = new byte[128];
            try {
                Configuration config = new Configuration();
                config.set(BlobServerOptions.CLEANUP_INTERVAL, (Object)1L);
                server = TestingBlobUtils.createServer(this.tempDir, config);
                server.start();
                cache = TestingBlobUtils.createPermanentCache(this.tempDir, config, server);
                keys.add(server.putPermanent(jobId, buf));
                buf[0] = (byte)(buf[0] + 1);
                keys.add(server.putPermanent(jobId, buf));
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
                cache.registerJob(jobId);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
                for (PermanentBlobKey key : keys) {
                    cache.getFile(jobId, key);
                }
                cache.registerJob(jobId);
                for (PermanentBlobKey key : keys) {
                    cache.getFile(jobId, key);
                }
                Assertions.assertThat((int)TestingBlobHelpers.checkFilesExist(jobId, keys, cache, true)).isEqualTo(2);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
                cache.releaseJob(jobId);
                Assertions.assertThat((int)TestingBlobHelpers.checkFilesExist(jobId, keys, cache, true)).isEqualTo(2);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
                cache.releaseJob(jobId);
                BlobCacheCleanupTest.verifyJobCleanup(cache, jobId, keys);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                if (cache == null) break block7;
            }
            catch (Throwable throwable) {
                if (cache != null) {
                    cache.close();
                }
                if (server != null) {
                    server.close();
                }
                TestingBlobHelpers.checkFileCountForJob(0, jobId, server);
                throw throwable;
            }
            cache.close();
        }
        if (server != null) {
            server.close();
        }
        TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)server);
    }

    @Test
    void testPermanentJobReferences() throws IOException {
        JobID jobId = new JobID();
        Configuration config = new Configuration();
        config.set(BlobServerOptions.CLEANUP_INTERVAL, (Object)3600000L);
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 12345);
        try (PermanentBlobCache cache = TestingBlobUtils.createPermanentCache(this.tempDir, config, serverAddress);){
            cache.registerJob(jobId);
            Assertions.assertThat((int)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).references).isOne();
            Assertions.assertThat((long)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).keepUntil).isEqualTo(-1L);
            cache.registerJob(jobId);
            Assertions.assertThat((int)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).references).isEqualTo(2);
            Assertions.assertThat((long)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).keepUntil).isEqualTo(-1L);
            cache.releaseJob(jobId);
            Assertions.assertThat((int)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).references).isOne();
            Assertions.assertThat((long)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).keepUntil).isEqualTo(-1L);
            long cleanupLowerBound = System.currentTimeMillis() + (Long)config.get(BlobServerOptions.CLEANUP_INTERVAL);
            cache.releaseJob(jobId);
            Assertions.assertThat((int)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).references).isZero();
            Assertions.assertThat((long)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).keepUntil).isGreaterThanOrEqualTo(cleanupLowerBound);
            cache.registerJob(jobId);
            Assertions.assertThat((int)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).references).isOne();
            Assertions.assertThat((long)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).keepUntil).isEqualTo(-1L);
            cleanupLowerBound = System.currentTimeMillis() + (Long)config.get(BlobServerOptions.CLEANUP_INTERVAL);
            cache.releaseJob(jobId);
            Assertions.assertThat((int)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).references).isZero();
            Assertions.assertThat((long)((PermanentBlobCache.RefCount)cache.getJobRefCounters().get((Object)jobId)).keepUntil).isGreaterThanOrEqualTo(cleanupLowerBound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Disabled(value="manual test due to stalling: ensures a BLOB is retained first and only deleted after the (long) timeout ")
    void testPermanentBlobDeferredCleanup() throws IOException, InterruptedException {
        BlobServer server;
        JobID jobId;
        block7: {
            long cleanupInterval = 5L;
            jobId = new JobID();
            ArrayList<PermanentBlobKey> keys = new ArrayList<PermanentBlobKey>();
            server = null;
            PermanentBlobCache cache = null;
            byte[] buf = new byte[128];
            try {
                Configuration config = new Configuration();
                config.set(BlobServerOptions.CLEANUP_INTERVAL, (Object)cleanupInterval);
                server = new BlobServer(config, TempDirUtils.newFolder((Path)this.tempDir), (BlobStore)new VoidBlobStore());
                server.start();
                BlobCacheSizeTracker tracker = new BlobCacheSizeTracker(MemorySize.ofMebiBytes((long)100L).getBytes());
                cache = TestingBlobUtils.createPermanentCache(this.tempDir, config, server, tracker);
                keys.add(server.putPermanent(jobId, buf));
                buf[0] = (byte)(buf[0] + 1);
                keys.add(server.putPermanent(jobId, buf));
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
                BlobCacheCleanupTest.checkBlobCacheSizeTracker(tracker, jobId, 0);
                cache.registerJob(jobId);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
                BlobCacheCleanupTest.checkBlobCacheSizeTracker(tracker, jobId, 0);
                for (PermanentBlobKey key : keys) {
                    cache.readFile(jobId, key);
                }
                cache.registerJob(jobId);
                for (PermanentBlobKey key : keys) {
                    cache.readFile(jobId, key);
                }
                Assertions.assertThat((int)TestingBlobHelpers.checkFilesExist(jobId, keys, cache, true)).isEqualTo(2);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
                BlobCacheCleanupTest.checkBlobCacheSizeTracker(tracker, jobId, 2);
                cache.releaseJob(jobId);
                Assertions.assertThat((int)TestingBlobHelpers.checkFilesExist(jobId, keys, cache, true)).isEqualTo(2);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
                BlobCacheCleanupTest.checkBlobCacheSizeTracker(tracker, jobId, 2);
                cache.releaseJob(jobId);
                Assertions.assertThat((int)TestingBlobHelpers.checkFilesExist(jobId, keys, cache, true)).isEqualTo(2);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
                Thread.sleep(cleanupInterval / 5L);
                Assertions.assertThat((int)TestingBlobHelpers.checkFilesExist(jobId, keys, cache, true)).isEqualTo(2);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
                Thread.sleep(cleanupInterval * 4L / 5L);
                BlobCacheCleanupTest.verifyJobCleanup(cache, jobId, keys);
                BlobCacheCleanupTest.checkBlobCacheSizeTracker(tracker, jobId, 0);
                TestingBlobHelpers.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
                if (cache == null) break block7;
            }
            catch (Throwable throwable) {
                if (cache != null) {
                    cache.close();
                }
                if (server != null) {
                    server.close();
                }
                TestingBlobHelpers.checkFileCountForJob(0, jobId, server);
                throw throwable;
            }
            cache.close();
        }
        if (server != null) {
            server.close();
        }
        TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)server);
    }

    @Test
    void testTransientBlobNoJobCleanup() throws Exception {
        this.testTransientBlobCleanup(null);
    }

    @Test
    void testTransientBlobForJobCleanup() throws Exception {
        this.testTransientBlobCleanup(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTransientBlobCleanup(@Nullable JobID jobId) throws Exception {
        long cleanupInterval = 1L;
        int numberConcurrentGetOperations = 3;
        ArrayList<CompletableFuture<Void>> getOperations = new ArrayList<CompletableFuture<Void>>(3);
        byte[] data = new byte[2000000];
        this.rnd.nextBytes(data);
        byte[] data2 = Arrays.copyOfRange(data, 10, 54);
        Configuration config = new Configuration();
        config.set(BlobServerOptions.CLEANUP_INTERVAL, (Object)cleanupInterval);
        Tuple2<BlobServer, BlobCacheService> serverAndCache = TestingBlobUtils.createServerAndCache(this.tempDir, config);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try (BlobServer server = (BlobServer)serverAndCache.f0;
             BlobCacheService cache = (BlobCacheService)serverAndCache.f1;){
            ConcurrentMap transientBlobExpiryTimes = cache.getTransientBlobService().getBlobExpiryTimes();
            server.start();
            TransientBlobKey key1 = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
            TransientBlobKey key2 = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data2, BlobKey.BlobType.TRANSIENT_BLOB);
            long cleanupLowerBound = System.currentTimeMillis() + cleanupInterval;
            BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key1, data);
            Long key1ExpiryFirstAccess = (Long)transientBlobExpiryTimes.get(Tuple2.of((Object)jobId, (Object)key1));
            Assertions.assertThat((Long)key1ExpiryFirstAccess).isGreaterThanOrEqualTo(cleanupLowerBound);
            Assertions.assertThat((Long)((Long)transientBlobExpiryTimes.get(Tuple2.of((Object)jobId, (Object)key2)))).isNull();
            Thread.sleep(1L);
            cleanupLowerBound = System.currentTimeMillis() + cleanupInterval;
            BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key2, data2);
            Assertions.assertThat((Long)key1ExpiryFirstAccess).isEqualTo(transientBlobExpiryTimes.get(Tuple2.of((Object)jobId, (Object)key1)));
            Assertions.assertThat((Long)((Long)transientBlobExpiryTimes.get(Tuple2.of((Object)jobId, (Object)key2)))).isGreaterThanOrEqualTo(cleanupLowerBound);
            if (jobId != null) {
                server.globalCleanupAsync(jobId, (Executor)executorService).join();
            } else {
                server.deleteFromCache(key1);
                server.deleteFromCache(key2);
            }
            TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)server);
            long finishTime = System.currentTimeMillis() + 3L * cleanupInterval;
            ExecutorService executor = Executors.newFixedThreadPool(3);
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<Void> getOperation = CompletableFuture.supplyAsync(() -> {
                    try {
                        while (System.currentTimeMillis() < finishTime) {
                            BlobServerGetTest.get((BlobService)cache, jobId, (BlobKey)key1);
                        }
                        return null;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not retrieve blob.", (Throwable)e));
                    }
                }, executor);
                getOperations.add(getOperation);
            }
            FutureUtils.ConjunctFuture filesFuture = FutureUtils.combineAll(getOperations);
            filesFuture.get();
            BlobCachePutTest.verifyDeletedEventually(server, jobId, new BlobKey[]{key1, key2});
        }
        finally {
            Assertions.assertThat(executorService.shutdownNow()).isEmpty();
        }
    }

    static void verifyJobCleanup(PermanentBlobCache cache, JobID jobId, List<? extends BlobKey> keys) throws InterruptedException, IOException {
        long deadline = System.currentTimeMillis() + 30000L;
        do {
            Thread.sleep(100L);
        } while (TestingBlobHelpers.checkFilesExist(jobId, keys, cache, false) != 0 && System.currentTimeMillis() < deadline);
        TestingBlobHelpers.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
    }

    private static void checkBlobCacheSizeTracker(BlobCacheSizeTracker tracker, JobID jobId, int expected) {
        Assertions.assertThat((Collection)tracker.getBlobKeysByJobId(jobId)).hasSize(expected);
    }
}

