/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;

public class LatencyStats {
    private final Map<String, DescriptiveStatisticsHistogram> latencyStats = new HashMap<String, DescriptiveStatisticsHistogram>();
    private final MetricGroup metricGroup;
    private final int historySize;
    private final int subtaskIndex;
    private final OperatorID operatorId;
    private final Granularity granularity;

    public LatencyStats(MetricGroup metricGroup, int historySize, int subtaskIndex, OperatorID operatorID, Granularity granularity) {
        this.metricGroup = metricGroup;
        this.historySize = historySize;
        this.subtaskIndex = subtaskIndex;
        this.operatorId = operatorID;
        this.granularity = granularity;
    }

    public void reportLatency(LatencyMarker marker) {
        String uniqueName = this.granularity.createUniqueHistogramName(marker, this.operatorId, this.subtaskIndex);
        DescriptiveStatisticsHistogram latencyHistogram = this.latencyStats.get(uniqueName);
        if (latencyHistogram == null) {
            latencyHistogram = new DescriptiveStatisticsHistogram(this.historySize);
            this.latencyStats.put(uniqueName, latencyHistogram);
            this.granularity.createSourceMetricGroups(this.metricGroup, marker, this.operatorId, this.subtaskIndex).addGroup("operator_id", String.valueOf((Object)this.operatorId)).addGroup("operator_subtask_index", String.valueOf(this.subtaskIndex)).histogram("latency", (Histogram)latencyHistogram);
        }
        long now = System.currentTimeMillis();
        latencyHistogram.update(now - marker.getMarkedTime());
    }

    public static enum Granularity {
        SINGLE{

            @Override
            String createUniqueHistogramName(LatencyMarker marker, OperatorID operatorId, int operatorSubtaskIndex) {
                return String.valueOf((Object)operatorId) + operatorSubtaskIndex;
            }

            @Override
            MetricGroup createSourceMetricGroups(MetricGroup base, LatencyMarker marker, OperatorID operatorId, int operatorSubtaskIndex) {
                return base;
            }
        }
        ,
        OPERATOR{

            @Override
            String createUniqueHistogramName(LatencyMarker marker, OperatorID operatorId, int operatorSubtaskIndex) {
                return String.valueOf((Object)marker.getOperatorId()) + String.valueOf((Object)operatorId) + operatorSubtaskIndex;
            }

            @Override
            MetricGroup createSourceMetricGroups(MetricGroup base, LatencyMarker marker, OperatorID operatorId, int operatorSubtaskIndex) {
                return base.addGroup("source_id", String.valueOf((Object)marker.getOperatorId()));
            }
        }
        ,
        SUBTASK{

            @Override
            String createUniqueHistogramName(LatencyMarker marker, OperatorID operatorId, int operatorSubtaskIndex) {
                return String.valueOf((Object)marker.getOperatorId()) + marker.getSubtaskIndex() + String.valueOf((Object)operatorId) + operatorSubtaskIndex;
            }

            @Override
            MetricGroup createSourceMetricGroups(MetricGroup base, LatencyMarker marker, OperatorID operatorId, int operatorSubtaskIndex) {
                return base.addGroup("source_id", String.valueOf((Object)marker.getOperatorId())).addGroup("source_subtask_index", String.valueOf(marker.getSubtaskIndex()));
            }
        };


        abstract String createUniqueHistogramName(LatencyMarker var1, OperatorID var2, int var3);

        abstract MetricGroup createSourceMetricGroups(MetricGroup var1, LatencyMarker var2, OperatorID var3, int var4);
    }
}

