/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

@Internal
public class JobManagerJobMetricGroup
extends JobMetricGroup<JobManagerMetricGroup> {
    private final Map<String, JobManagerOperatorMetricGroup> operators = new HashMap<String, JobManagerOperatorMetricGroup>();

    JobManagerJobMetricGroup(MetricRegistry registry, JobManagerMetricGroup parent, JobID jobId, @Nullable String jobName) {
        super(registry, (JobManagerMetricGroup)Preconditions.checkNotNull((Object)parent), jobId, jobName, registry.getScopeFormats().getJobManagerJobFormat().formatScope((JobManagerMetricGroup)Preconditions.checkNotNull((Object)parent), jobId, jobName));
    }

    public final JobManagerMetricGroup parent() {
        return (JobManagerMetricGroup)this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobManagerOperatorMetricGroup getOrAddOperator(AbstractID vertexId, String taskName, OperatorID operatorID, String operatorName) {
        String truncatedOperatorName = MetricUtils.truncateOperatorName(operatorName);
        String key = String.valueOf((Object)operatorID) + truncatedOperatorName;
        JobManagerJobMetricGroup jobManagerJobMetricGroup = this;
        synchronized (jobManagerJobMetricGroup) {
            return this.operators.computeIfAbsent(key, operator -> new JobManagerOperatorMetricGroup(this.registry, this, vertexId, taskName, operatorID, truncatedOperatorName));
        }
    }

    @VisibleForTesting
    int numRegisteredOperatorMetricGroups() {
        return this.operators.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOperatorMetricGroup(OperatorID operatorID, String operatorName) {
        String truncatedOperatorName = MetricUtils.truncateOperatorName(operatorName);
        String key = String.valueOf((Object)operatorID) + truncatedOperatorName;
        JobManagerJobMetricGroup jobManagerJobMetricGroup = this;
        synchronized (jobManagerJobMetricGroup) {
            if (!this.isClosed()) {
                this.operators.remove(key);
            }
        }
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup<?>> subComponents() {
        return this.operators.values();
    }
}

