/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.util.Preconditions;

public abstract class MetricDump {
    public static final byte METRIC_CATEGORY_COUNTER = 0;
    public static final byte METRIC_CATEGORY_GAUGE = 1;
    public static final byte METRIC_CATEGORY_HISTOGRAM = 2;
    public static final byte METRIC_CATEGORY_METER = 3;
    public final QueryScopeInfo scopeInfo;
    public final String name;

    private MetricDump(QueryScopeInfo scopeInfo, String name) {
        this.scopeInfo = (QueryScopeInfo)Preconditions.checkNotNull((Object)scopeInfo);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public abstract byte getCategory();

    public String toString() {
        return "MetricDump{scopeInfo=" + String.valueOf(this.scopeInfo) + ", name='" + this.name + "', category='" + this.getCategory() + "'}";
    }

    public static class MeterDump
    extends MetricDump {
        public final double rate;

        public MeterDump(QueryScopeInfo scopeInfo, String name, double rate) {
            super(scopeInfo, name);
            this.rate = rate;
        }

        @Override
        public byte getCategory() {
            return 3;
        }
    }

    public static class HistogramDump
    extends MetricDump {
        public final long min;
        public final long max;
        public final double mean;
        public final double median;
        public final double stddev;
        public final double p75;
        public final double p90;
        public final double p95;
        public final double p98;
        public final double p99;
        public final double p999;

        public HistogramDump(QueryScopeInfo scopeInfo, String name, long min, long max, double mean, double median, double stddev, double p75, double p90, double p95, double p98, double p99, double p999) {
            super(scopeInfo, name);
            this.min = min;
            this.max = max;
            this.mean = mean;
            this.median = median;
            this.stddev = stddev;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p98 = p98;
            this.p99 = p99;
            this.p999 = p999;
        }

        @Override
        public byte getCategory() {
            return 2;
        }
    }

    public static class GaugeDump
    extends MetricDump {
        public final String value;

        public GaugeDump(QueryScopeInfo scopeInfo, String name, String value) {
            super(scopeInfo, name);
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        @Override
        public byte getCategory() {
            return 1;
        }
    }

    public static class CounterDump
    extends MetricDump {
        public final long count;

        public CounterDump(QueryScopeInfo scopeInfo, String name, long count) {
            super(scopeInfo, name);
            this.count = count;
        }

        @Override
        public byte getCategory() {
            return 0;
        }
    }
}

