/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.runtime.asyncprocessing.AsyncRequest;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.internal.InternalPartitionedState;

public class StateRequest<K, N, IN, OUT>
extends AsyncRequest<K>
implements Serializable {
    @Nonnull
    private final State state;
    private final StateRequestType type;
    @Nullable
    private final IN payload;
    @Nonnull
    private final N namespace;

    public StateRequest(@Nonnull State state, StateRequestType type, boolean sync, @Nullable IN payload, InternalAsyncFuture<OUT> stateFuture, RecordContext<K> context) {
        super(context, sync, stateFuture);
        this.state = state;
        this.type = type;
        this.payload = payload;
        this.namespace = context.getNamespace((InternalPartitionedState)state);
    }

    public StateRequestType getRequestType() {
        return this.type;
    }

    @Nullable
    public IN getPayload() {
        return this.payload;
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    @Override
    public InternalAsyncFuture<OUT> getFuture() {
        return this.asyncFuture;
    }

    @Nonnull
    public N getNamespace() {
        return this.namespace;
    }
}

