/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.core.asyncprocessing.AsyncFutureImpl;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutor;
import org.apache.flink.runtime.asyncprocessing.EpochManager;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.asyncprocessing.declare.DeclarationManager;
import org.apache.flink.runtime.state.v2.internal.InternalPartitionedState;

public class StateExecutionController<K>
extends AsyncExecutionController<K, StateRequest<?, ?, ?, ?>>
implements StateRequestHandler {
    public StateExecutionController(MailboxExecutor mailboxExecutor, AsyncFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler, AsyncExecutor<StateRequest<?, ?, ?, ?>> stateExecutor, DeclarationManager declarationManager, EpochManager.ParallelMode epochParallelMode, int maxParallelism, int batchSize, long bufferTimeout, int maxInFlightRecords, @Nullable AsyncExecutionController.SwitchContextListener<K> switchContextListener, @Nullable MetricGroup metricGroup) {
        super(mailboxExecutor, exceptionHandler, stateExecutor, declarationManager, epochParallelMode, maxParallelism, batchSize, bufferTimeout, maxInFlightRecords, switchContextListener, metricGroup);
    }

    @Override
    public <IN, OUT> InternalAsyncFuture<OUT> handleRequest(@Nullable State state, StateRequestType type, @Nullable IN payload) {
        return this.handleRequest(state, type, false, payload, false);
    }

    public <IN, OUT> InternalAsyncFuture<OUT> handleRequest(@Nullable State state, StateRequestType type, boolean sync, @Nullable IN payload, boolean allowOverdraft) {
        InternalAsyncFuture stateFuture = this.asyncFutureFactory.create(this.currentContext);
        StateRequest request = new StateRequest(state, type, sync, payload, stateFuture, this.currentContext);
        this.handleRequest(request, allowOverdraft);
        return stateFuture;
    }

    @Override
    public <IN, OUT> OUT handleRequestSync(State state, StateRequestType type, @Nullable IN payload) {
        InternalAsyncFuture<OUT> stateFuture = this.handleRequest(state, type, true, payload, false);
        this.waitUntil(() -> stateFuture.isDone());
        return (OUT)stateFuture.get();
    }

    @Override
    public <N> void setCurrentNamespaceForState(@Nonnull InternalPartitionedState<N> state, N namespace) {
        this.currentContext.setNamespace(state, namespace);
    }
}

