/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.runtime.operators.windowing.TriggerTestHarness;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ProcessingTimeTriggerTest {
    ProcessingTimeTriggerTest() {
    }

    @Test
    void testWindowSeparationAndFiring() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isOne();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(2L, new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isOne();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(4L, new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testClear() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isOne();
        testHarness.clearTriggerState(new TimeWindow(2L, 4L));
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isZero();
        testHarness.clearTriggerState(new TimeWindow(0L, 2L));
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testMergingWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((boolean)ProcessingTimeTrigger.create().canMerge()).isTrue();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isOne();
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 4L))).isOne();
        Assertions.assertThat((Comparable)testHarness.advanceProcessingTime(4L, new TimeWindow(0L, 4L))).isEqualTo((Object)TriggerResult.FIRE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
    }

    @Test
    void testMergingLateWindows() throws Exception {
        TriggerTestHarness testHarness = new TriggerTestHarness(ProcessingTimeTrigger.create(), (TypeSerializer<TimeWindow>)new TimeWindow.Serializer());
        Assertions.assertThat((boolean)ProcessingTimeTrigger.create().canMerge()).isTrue();
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(0L, 2L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((Comparable)testHarness.processElement(new StreamRecord((Object)1), new TimeWindow(2L, 4L))).isEqualTo((Object)TriggerResult.CONTINUE);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isEqualTo(2);
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isOne();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isOne();
        testHarness.advanceProcessingTime(10L);
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isZero();
        testHarness.mergeWindows(new TimeWindow(0L, 4L), Lists.newArrayList((Object[])new TimeWindow[]{new TimeWindow(0L, 2L), new TimeWindow(2L, 4L)}));
        Assertions.assertThat((int)testHarness.numStateEntries()).isZero();
        Assertions.assertThat((int)testHarness.numEventTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers()).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 2L))).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(2L, 4L))).isZero();
        Assertions.assertThat((int)testHarness.numProcessingTimeTimers(new TimeWindow(0L, 4L))).isZero();
    }
}

