/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.streaming.api.operators.MapPartitionOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MapPartitionOperatorTest {
    private static final String RECORD = "TEST";

    MapPartitionOperatorTest() {
    }

    @Test
    void testMapPartition() throws Exception {
        MapPartitionOperator mapPartitionOperator = new MapPartitionOperator((MapPartitionFunction)new MapPartition(new CompletableFuture<Object>(), new CompletableFuture<Object>()));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(mapPartitionOperator);
        LinkedList<StreamRecord> expectedOutput = new LinkedList<StreamRecord>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)RECORD));
        testHarness.processElement(new StreamRecord((Object)RECORD));
        testHarness.processElement(new StreamRecord((Object)RECORD));
        testHarness.endInput();
        expectedOutput.add(new StreamRecord((Object)3));
        TestHarnessUtil.assertOutputEquals("The result of map partition is not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }

    @Test
    void testOpenClose() throws Exception {
        CompletableFuture<Object> openIdentifier = new CompletableFuture<Object>();
        CompletableFuture<Object> closeIdentifier = new CompletableFuture<Object>();
        MapPartitionOperator mapPartitionOperator = new MapPartitionOperator((MapPartitionFunction)new MapPartition(openIdentifier, closeIdentifier));
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(mapPartitionOperator);
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)RECORD));
        testHarness.endInput();
        testHarness.close();
        Assertions.assertThat(openIdentifier).isCompleted();
        Assertions.assertThat(closeIdentifier).isCompleted();
        Assertions.assertThat(testHarness.getOutput()).isNotEmpty();
    }

    private static class MapPartition
    extends RichMapPartitionFunction<String, Integer> {
        private final CompletableFuture<Object> openIdentifier;
        private final CompletableFuture<Object> closeIdentifier;

        public MapPartition(CompletableFuture<Object> openIdentifier, CompletableFuture<Object> closeIdentifier) {
            this.openIdentifier = openIdentifier;
            this.closeIdentifier = closeIdentifier;
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            this.openIdentifier.complete(null);
        }

        public void mapPartition(Iterable<String> values, Collector<Integer> out) {
            ArrayList<String> result = new ArrayList<String>();
            for (String value : values) {
                result.add(value);
            }
            out.collect((Object)result.size());
        }

        public void close() throws Exception {
            super.close();
            this.closeIdentifier.complete(null);
        }
    }
}

