/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.TriggerSavepointMode;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.messages.ThreadDumpInfo;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.TriFunction;

public final class TestingDispatcherGateway
extends TestingRestfulGateway
implements DispatcherGateway {
    static final Function<ExecutionPlan, CompletableFuture<Acknowledge>> DEFAULT_SUBMIT_FUNCTION = jobGraph -> CompletableFuture.completedFuture(Acknowledge.get());
    static final TriFunction<JobID, String, Throwable, CompletableFuture<Acknowledge>> DEFAULT_SUBMIT_FAILED_FUNCTION = (jobId, jobName, Throwable2) -> CompletableFuture.completedFuture(Acknowledge.get());
    static final Supplier<CompletableFuture<Collection<JobID>>> DEFAULT_LIST_FUNCTION = () -> CompletableFuture.completedFuture(Collections.emptyList());
    static final int DEFAULT_BLOB_SERVER_PORT = 1234;
    static final DispatcherId DEFAULT_FENCING_TOKEN = DispatcherId.generate();
    static final Function<JobID, CompletableFuture<ArchivedExecutionGraph>> DEFAULT_REQUEST_ARCHIVED_JOB_FUNCTION = jobID -> CompletableFuture.completedFuture(null);
    static final Function<ApplicationStatus, CompletableFuture<Acknowledge>> DEFAULT_SHUTDOWN_WITH_STATUS_FUNCTION = status -> CompletableFuture.completedFuture(Acknowledge.get());
    static final TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> DEFAULT_TRIGGER_SAVEPOINT_AND_GET_LOCATION_FUNCTION = (jobId, targetDirectory, formatType) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> DEFAULT_STOP_WITH_SAVEPOINT_AND_GET_LOCATION_FUNCTION = (jobId, targetDirectory, formatType) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final BiFunction<JobID, CheckpointType, CompletableFuture<Long>> DEFAULT_TRIGGER_CHECHPOINT_AND_GET_CHECKPOINT_ID_FUNCTION = (jobId, checkpointType) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    private final Function<ExecutionPlan, CompletableFuture<Acknowledge>> submitFunction;
    private final TriFunction<JobID, String, Throwable, CompletableFuture<Acknowledge>> submitFailedFunction;
    private final Supplier<CompletableFuture<Collection<JobID>>> listFunction;
    private final int blobServerPort;
    private final DispatcherId fencingToken;
    private final Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction;
    private final Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownWithStatusFunction;
    private final TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> triggerSavepointAndGetLocationFunction;
    private final TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> stopWithSavepointAndGetLocationFunction;
    private final BiFunction<JobID, CheckpointType, CompletableFuture<Long>> triggerCheckpointAndGetCheckpointIdFunction;

    public TestingDispatcherGateway() {
        this.submitFunction = DEFAULT_SUBMIT_FUNCTION;
        this.submitFailedFunction = DEFAULT_SUBMIT_FAILED_FUNCTION;
        this.listFunction = DEFAULT_LIST_FUNCTION;
        this.blobServerPort = 1234;
        this.fencingToken = DEFAULT_FENCING_TOKEN;
        this.requestArchivedJobFunction = DEFAULT_REQUEST_ARCHIVED_JOB_FUNCTION;
        this.clusterShutdownWithStatusFunction = DEFAULT_SHUTDOWN_WITH_STATUS_FUNCTION;
        this.triggerSavepointAndGetLocationFunction = DEFAULT_TRIGGER_SAVEPOINT_AND_GET_LOCATION_FUNCTION;
        this.stopWithSavepointAndGetLocationFunction = DEFAULT_STOP_WITH_SAVEPOINT_AND_GET_LOCATION_FUNCTION;
        this.triggerCheckpointAndGetCheckpointIdFunction = DEFAULT_TRIGGER_CHECHPOINT_AND_GET_CHECKPOINT_ID_FUNCTION;
    }

    public TestingDispatcherGateway(String address, String hostname, Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction, Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction, Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestExecutionGraphInfoFunction, Function<JobID, CompletableFuture<CheckpointStatsSnapshot>> requestCheckpointStatsSnapshotFunction, Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction, Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction, Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier, Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier, Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServiceAddressesSupplier, Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServiceGatewaysSupplier, Supplier<CompletableFuture<ThreadDumpInfo>> requestThreadDumpSupplier, BiFunction<AsynchronousJobOperationKey, CheckpointType, CompletableFuture<Acknowledge>> triggerCheckpointFunction, Function<AsynchronousJobOperationKey, CompletableFuture<OperationResult<Long>>> getCheckpointStatusFunction, TriFunction<AsynchronousJobOperationKey, String, SavepointFormatType, CompletableFuture<Acknowledge>> triggerSavepointFunction, TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> triggerSavepointAndGetLocationFunction, TriFunction<AsynchronousJobOperationKey, String, SavepointFormatType, CompletableFuture<Acknowledge>> stopWithSavepointFunction, TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> stopWithSavepointAndGetLocationFunction, Function<AsynchronousJobOperationKey, CompletableFuture<OperationResult<String>>> getSavepointStatusFunction, BiFunction<JobID, CheckpointType, CompletableFuture<Long>> triggerCheckpointAndGetCheckpointIdFunction, Function<ExecutionPlan, CompletableFuture<Acknowledge>> submitFunction, TriFunction<JobID, String, Throwable, CompletableFuture<Acknowledge>> submitFailedFunction, Supplier<CompletableFuture<Collection<JobID>>> listFunction, int blobServerPort, DispatcherId fencingToken, Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction, Supplier<CompletableFuture<Acknowledge>> clusterShutdownSupplier, Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownWithStatusFunction, TriFunction<JobID, String, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestToCoordinatorFunction) {
        super(address, hostname, cancelJobFunction, requestJobFunction, requestExecutionGraphInfoFunction, requestCheckpointStatsSnapshotFunction, requestJobResultFunction, requestJobStatusFunction, requestMultipleJobDetailsSupplier, requestClusterOverviewSupplier, requestMetricQueryServiceAddressesSupplier, requestTaskManagerMetricQueryServiceGatewaysSupplier, requestThreadDumpSupplier, triggerCheckpointFunction, getCheckpointStatusFunction, triggerSavepointFunction, stopWithSavepointFunction, getSavepointStatusFunction, clusterShutdownSupplier, deliverCoordinationRequestToCoordinatorFunction);
        this.submitFunction = submitFunction;
        this.submitFailedFunction = submitFailedFunction;
        this.listFunction = listFunction;
        this.blobServerPort = blobServerPort;
        this.fencingToken = fencingToken;
        this.requestArchivedJobFunction = requestArchivedJobFunction;
        this.clusterShutdownWithStatusFunction = clusterShutdownWithStatusFunction;
        this.triggerSavepointAndGetLocationFunction = triggerSavepointAndGetLocationFunction;
        this.stopWithSavepointAndGetLocationFunction = stopWithSavepointAndGetLocationFunction;
        this.triggerCheckpointAndGetCheckpointIdFunction = triggerCheckpointAndGetCheckpointIdFunction;
    }

    public CompletableFuture<Acknowledge> submitJob(ExecutionPlan executionPlan, Duration timeout) {
        return this.submitFunction.apply(executionPlan);
    }

    public CompletableFuture<Acknowledge> submitFailedJob(JobID jobId, String jobName, Throwable exception) {
        return (CompletableFuture)this.submitFailedFunction.apply((Object)jobId, (Object)jobName, (Object)exception);
    }

    public CompletableFuture<Collection<JobID>> listJobs(Duration timeout) {
        return this.listFunction.get();
    }

    public CompletableFuture<Integer> getBlobServerPort(Duration timeout) {
        return CompletableFuture.completedFuture(this.blobServerPort);
    }

    public DispatcherId getFencingToken() {
        return DEFAULT_FENCING_TOKEN;
    }

    @Override
    public CompletableFuture<ArchivedExecutionGraph> requestJob(JobID jobId, @RpcTimeout Duration timeout) {
        return this.requestArchivedJobFunction.apply(jobId);
    }

    public CompletableFuture<Acknowledge> shutDownCluster(ApplicationStatus applicationStatus) {
        return this.clusterShutdownWithStatusFunction.apply(applicationStatus);
    }

    public CompletableFuture<String> triggerSavepointAndGetLocation(JobID jobId, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Duration timeout) {
        return (CompletableFuture)this.triggerSavepointAndGetLocationFunction.apply((Object)jobId, (Object)targetDirectory, (Object)formatType);
    }

    public CompletableFuture<String> stopWithSavepointAndGetLocation(JobID jobId, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Duration timeout) {
        return (CompletableFuture)this.stopWithSavepointAndGetLocationFunction.apply((Object)jobId, (Object)targetDirectory, (Object)formatType);
    }

    public CompletableFuture<Long> triggerCheckpointAndGetCheckpointID(JobID jobId, CheckpointType checkpointType, Duration timeout) {
        return this.triggerCheckpointAndGetCheckpointIdFunction.apply(jobId, checkpointType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    extends TestingRestfulGateway.AbstractBuilder<Builder> {
        private Function<ExecutionPlan, CompletableFuture<Acknowledge>> submitFunction;
        private TriFunction<JobID, String, Throwable, CompletableFuture<Acknowledge>> submitFailedFunction;
        private Supplier<CompletableFuture<Collection<JobID>>> listFunction;
        private int blobServerPort;
        private DispatcherId fencingToken;
        private Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction;
        private Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownWithStatusFunction = DEFAULT_SHUTDOWN_WITH_STATUS_FUNCTION;
        private TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> triggerSavepointAndGetLocationFunction;
        private TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> stopWithSavepointAndGetLocationFunction;
        private BiFunction<JobID, CheckpointType, CompletableFuture<Long>> triggerCheckpointAndGetCheckpointIdFunction;

        private Builder() {
        }

        public Builder setSubmitFunction(Function<ExecutionPlan, CompletableFuture<Acknowledge>> submitFunction) {
            this.submitFunction = submitFunction;
            return this;
        }

        public Builder setSubmitFailedFunction(TriFunction<JobID, String, Throwable, CompletableFuture<Acknowledge>> submitFailedFunction) {
            this.submitFailedFunction = submitFailedFunction;
            return this;
        }

        public Builder setListFunction(Supplier<CompletableFuture<Collection<JobID>>> listFunction) {
            this.listFunction = listFunction;
            return this;
        }

        public Builder setRequestArchivedJobFunction(Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction) {
            this.requestArchivedJobFunction = requestJobFunction;
            return this;
        }

        public Builder setClusterShutdownFunction(Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownFunction) {
            this.clusterShutdownWithStatusFunction = clusterShutdownFunction;
            return this;
        }

        @Override
        public Builder setRequestJobFunction(Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction) {
            throw new UnsupportedOperationException("Use setRequestArchivedJobFunction() instead.");
        }

        public Builder setTriggerSavepointAndGetLocationFunction(TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> triggerSavepointAndGetLocationFunction) {
            this.triggerSavepointAndGetLocationFunction = triggerSavepointAndGetLocationFunction;
            return this;
        }

        public Builder setStopWithSavepointAndGetLocationFunction(TriFunction<JobID, String, SavepointFormatType, CompletableFuture<String>> stopWithSavepointAndGetLocationFunction) {
            this.stopWithSavepointAndGetLocationFunction = stopWithSavepointAndGetLocationFunction;
            return this;
        }

        public Builder setTriggerCheckpointAndGetCheckpointIdFunction(BiFunction<JobID, CheckpointType, CompletableFuture<Long>> triggerCheckpointAndGetCheckpointIdFunction) {
            this.triggerCheckpointAndGetCheckpointIdFunction = triggerCheckpointAndGetCheckpointIdFunction;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setBlobServerPort(int blobServerPort) {
            this.blobServerPort = blobServerPort;
            return this;
        }

        public Builder setFencingToken(DispatcherId fencingToken) {
            this.fencingToken = fencingToken;
            return this;
        }

        @Override
        public TestingDispatcherGateway build() {
            return new TestingDispatcherGateway(this.address, this.hostname, this.cancelJobFunction, this.requestJobFunction, this.requestExecutionGraphInfoFunction, this.requestCheckpointStatsSnapshotFunction, this.requestJobResultFunction, this.requestJobStatusFunction, this.requestMultipleJobDetailsSupplier, this.requestClusterOverviewSupplier, this.requestMetricQueryServiceGatewaysSupplier, this.requestTaskManagerMetricQueryServiceGatewaysSupplier, this.requestThreadDumpSupplier, this.triggerCheckpointFunction, this.getCheckpointStatusFunction, (TriFunction<AsynchronousJobOperationKey, String, SavepointFormatType, CompletableFuture<Acknowledge>>)this.triggerSavepointFunction, this.triggerSavepointAndGetLocationFunction, (TriFunction<AsynchronousJobOperationKey, String, SavepointFormatType, CompletableFuture<Acknowledge>>)this.stopWithSavepointFunction, this.stopWithSavepointAndGetLocationFunction, this.getSavepointStatusFunction, this.triggerCheckpointAndGetCheckpointIdFunction, this.submitFunction, this.submitFailedFunction, this.listFunction, this.blobServerPort, this.fencingToken, this.requestArchivedJobFunction, this.clusterShutdownSupplier, this.clusterShutdownWithStatusFunction, (TriFunction<JobID, String, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>>)this.deliverCoordinationRequestToCoordinatorFunction);
        }
    }
}

