/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.BatchExecutionOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.shuffle.NettyShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.ShuffleMasterContextImpl;
import org.apache.flink.runtime.shuffle.ShuffleMasterSnapshot;
import org.apache.flink.runtime.shuffle.ShuffleMasterSnapshotUtil;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ShuffleMasterSnapshotUtilTest {
    private ShuffleMaster<?> shuffleMaster;
    private Configuration configuration;
    private ShuffleMasterSnapshot restoredSnapshot;
    private boolean triggeredSnapshot;
    @TempDir
    java.nio.file.Path temporaryFolder;

    ShuffleMasterSnapshotUtilTest() {
    }

    @BeforeEach
    public void setUp() {
        this.shuffleMaster = new NettyShuffleMaster((ShuffleMasterContext)new ShuffleMasterContextImpl(new Configuration(), throwable -> {})){

            public void snapshotState(CompletableFuture<ShuffleMasterSnapshot> snapshotFuture) {
                snapshotFuture.complete(new TestingShuffleMasterSnapshot());
                ShuffleMasterSnapshotUtilTest.this.triggeredSnapshot = true;
            }

            public void restoreState(ShuffleMasterSnapshot snapshot) {
                ShuffleMasterSnapshotUtilTest.this.restoredSnapshot = snapshot;
            }
        };
        this.restoredSnapshot = null;
        this.triggeredSnapshot = false;
        this.configuration = new Configuration();
        this.configuration.set(BatchExecutionOptions.JOB_RECOVERY_ENABLED, (Object)true);
        this.configuration.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)this.temporaryFolder.toString());
    }

    @Test
    void testRestoreOrSnapshotShuffleMaster() throws IOException {
        String clusterId = (String)this.configuration.get(HighAvailabilityOptions.HA_CLUSTER_ID);
        Path path = new Path(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)this.configuration), "shuffleMaster-snapshot");
        FileSystem fileSystem = path.getFileSystem();
        Assertions.assertThat((boolean)fileSystem.exists(new Path(path, clusterId))).isFalse();
        Assertions.assertThat((boolean)ShuffleMasterSnapshotUtil.isShuffleMasterSnapshotExist((Path)path, (String)clusterId)).isFalse();
        ShuffleMasterSnapshotUtil.restoreOrSnapshotShuffleMaster(this.shuffleMaster, (Configuration)this.configuration, (Executor)Executors.directExecutor());
        Assertions.assertThat((boolean)fileSystem.exists(new Path(path, clusterId))).isTrue();
        Assertions.assertThat((boolean)ShuffleMasterSnapshotUtil.isShuffleMasterSnapshotExist((Path)path, (String)clusterId)).isTrue();
        ShuffleMasterSnapshot snapshot = ShuffleMasterSnapshotUtil.readSnapshot((Path)path, (String)clusterId);
        Assertions.assertThat((Object)snapshot).isInstanceOf(TestingShuffleMasterSnapshot.class);
        Assertions.assertThat((Object)this.restoredSnapshot).isNull();
        Assertions.assertThat((boolean)this.triggeredSnapshot).isTrue();
        this.triggeredSnapshot = false;
        ShuffleMasterSnapshotUtil.restoreOrSnapshotShuffleMaster(this.shuffleMaster, (Configuration)this.configuration, (Executor)Executors.directExecutor());
        Assertions.assertThat((Object)this.restoredSnapshot).isInstanceOf(TestingShuffleMasterSnapshot.class);
        Assertions.assertThat((boolean)this.triggeredSnapshot).isFalse();
    }

    private static final class TestingShuffleMasterSnapshot
    implements ShuffleMasterSnapshot {
        private TestingShuffleMasterSnapshot() {
        }

        public boolean isIncremental() {
            return false;
        }
    }
}

