/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.active.WorkerCounter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WorkerCounterTest {
    WorkerCounterTest() {
    }

    @Test
    void testWorkerCounterIncreaseAndDecrease() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(2.0).build();
        WorkerCounter counter = new WorkerCounter();
        Assertions.assertThat((int)counter.getTotalNum()).isZero();
        Assertions.assertThat((int)counter.getNum(spec1)).isZero();
        Assertions.assertThat((int)counter.getNum(spec2)).isZero();
        Assertions.assertThat((int)counter.increaseAndGet(spec1)).isOne();
        Assertions.assertThat((int)counter.getTotalNum()).isOne();
        Assertions.assertThat((int)counter.getNum(spec1)).isOne();
        Assertions.assertThat((int)counter.getNum(spec2)).isZero();
        Assertions.assertThat((int)counter.increaseAndGet(spec1)).isEqualTo(2);
        Assertions.assertThat((int)counter.getTotalNum()).isEqualTo(2);
        Assertions.assertThat((int)counter.getNum(spec1)).isEqualTo(2);
        Assertions.assertThat((int)counter.getNum(spec2)).isZero();
        Assertions.assertThat((int)counter.increaseAndGet(spec2)).isOne();
        Assertions.assertThat((int)counter.getTotalNum()).isEqualTo(3);
        Assertions.assertThat((int)counter.getNum(spec1)).isEqualTo(2);
        Assertions.assertThat((int)counter.getNum(spec2)).isOne();
        Assertions.assertThat((int)counter.decreaseAndGet(spec1)).isOne();
        Assertions.assertThat((int)counter.getTotalNum()).isEqualTo(2);
        Assertions.assertThat((int)counter.getNum(spec1)).isOne();
        Assertions.assertThat((int)counter.getNum(spec2)).isOne();
        Assertions.assertThat((int)counter.decreaseAndGet(spec2)).isZero();
        Assertions.assertThat((int)counter.getTotalNum()).isOne();
        Assertions.assertThat((int)counter.getNum(spec1)).isOne();
        Assertions.assertThat((int)counter.getNum(spec2)).isZero();
    }

    @Test
    void testWorkerCounterDecreaseOnZero() {
        WorkerResourceSpec spec = new WorkerResourceSpec.Builder().build();
        WorkerCounter counter = new WorkerCounter();
        Assertions.assertThatThrownBy(() -> counter.decreaseAndGet(spec)).isInstanceOf(IllegalStateException.class);
    }
}

