/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.active.ActiveResourceManagerFactory;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.ConfigurationException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ActiveResourceManagerFactoryTest {
    private static final MemorySize TOTAL_FLINK_SIZE = MemorySize.ofMebiBytes((long)2048L);
    private static final MemorySize TOTAL_PROCESS_SIZE = MemorySize.ofMebiBytes((long)3072L);

    ActiveResourceManagerFactoryTest() {
    }

    @Test
    void testGetEffectiveConfigurationForResourceManagerFineGrained() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.TOTAL_FLINK_MEMORY, (Object)TOTAL_FLINK_SIZE);
        config.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)TOTAL_PROCESS_SIZE);
        Configuration effectiveConfig = ActiveResourceManagerFactoryTest.getFactory().getEffectiveConfigurationForResourceManager(config);
        Assertions.assertThat((boolean)effectiveConfig.contains(TaskManagerOptions.TOTAL_FLINK_MEMORY)).isFalse();
        Assertions.assertThat((boolean)effectiveConfig.contains(TaskManagerOptions.TOTAL_PROCESS_MEMORY)).isFalse();
    }

    private static ActiveResourceManagerFactory<ResourceID> getFactory() {
        return new ActiveResourceManagerFactory<ResourceID>(){

            protected ResourceManagerRuntimeServicesConfiguration createResourceManagerRuntimeServicesConfiguration(Configuration configuration) throws ConfigurationException {
                return null;
            }

            protected ResourceManagerDriver<ResourceID> createResourceManagerDriver(Configuration configuration, @Nullable String webInterfaceUrl, String rpcAddress) throws Exception {
                return null;
            }
        };
    }
}

