/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.util.MutableObjectIterator;

public class UniformIntPairGenerator
implements MutableObjectIterator<IntPair> {
    final int numKeys;
    final int numVals;
    int keyCnt = 0;
    int valCnt = 0;
    boolean repeatKey;

    public UniformIntPairGenerator(int numKeys, int numVals, boolean repeatKey) {
        this.numKeys = numKeys;
        this.numVals = numVals;
        this.repeatKey = repeatKey;
    }

    public IntPair next(IntPair target) {
        if (!this.repeatKey) {
            if (this.valCnt >= this.numVals) {
                return null;
            }
            target.setKey(this.keyCnt++);
            target.setValue(this.valCnt);
            if (this.keyCnt == this.numKeys) {
                this.keyCnt = 0;
                ++this.valCnt;
            }
        } else {
            if (this.keyCnt >= this.numKeys) {
                return null;
            }
            target.setKey(this.keyCnt);
            target.setValue(this.valCnt++);
            if (this.valCnt == this.numVals) {
                this.valCnt = 0;
                ++this.keyCnt;
            }
        }
        return target;
    }

    public IntPair next() {
        return this.next(new IntPair());
    }
}

