/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TraceOptions;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.runtime.metrics.ReporterSetupBuilder;
import org.apache.flink.runtime.metrics.TraceReporterSetup;
import org.apache.flink.runtime.metrics.filter.DefaultReporterFilters;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.TestTraceReporter;
import org.apache.flink.testutils.junit.extensions.ContextClassLoaderExtension;
import org.apache.flink.traces.reporter.TraceReporter;
import org.apache.flink.traces.reporter.TraceReporterFactory;
import org.apache.flink.util.TestLoggerExtension;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={TestLoggerExtension.class})
class TraceSetupTest {
    @RegisterExtension
    static final ContextClassLoaderExtension CONTEXT_CLASS_LOADER_EXTENSION = ContextClassLoaderExtension.builder().withServiceEntry(TraceReporterFactory.class, new String[]{TestTraceReporter1.class.getName(), TestTraceReporter2.class.getName(), TestTraceReporter11.class.getName(), TestTraceReporter12.class.getName(), TestTraceReporter13.class.getName(), TestTraceReporterFactory.class.getName(), FailingFactory.class.getName(), ConfigExposingReporterFactory.class.getName()}).build();

    TraceSetupTest() {
    }

    @Test
    void testReporterArgumentForwarding() {
        Configuration config = new Configuration();
        TraceSetupTest.configureReporter1(config);
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        TraceReporterSetup reporterSetup = (TraceReporterSetup)reporterSetups.get(0);
        TraceSetupTest.assertTraceReporter1Configured(reporterSetup);
    }

    @Test
    void testSeveralReportersWithArgumentForwarding() {
        Configuration config = new Configuration();
        TraceSetupTest.configureReporter1(config);
        TraceSetupTest.configureReporter2(config);
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)2L, (long)reporterSetups.size());
        Optional<TraceReporterSetup> reporter1Config = reporterSetups.stream().filter(c -> "reporter1".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter1Config.isPresent());
        TraceSetupTest.assertTraceReporter1Configured(reporter1Config.get());
        Optional<TraceReporterSetup> reporter2Config = reporterSetups.stream().filter(c -> "reporter2".equals(c.getName())).findFirst();
        Assert.assertTrue((boolean)reporter2Config.isPresent());
        TraceSetupTest.assertReporter2Configured(reporter2Config.get());
    }

    @Test
    void testActivateOneReporterAmongTwoDeclared() {
        Configuration config = new Configuration();
        TraceSetupTest.configureReporter1(config);
        TraceSetupTest.configureReporter2(config);
        config.set(TraceOptions.TRACE_REPORTERS_LIST, (Object)"reporter2");
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        TraceReporterSetup setup = (TraceReporterSetup)reporterSetups.get(0);
        TraceSetupTest.assertReporter2Configured(setup);
    }

    @Test
    void testReporterSetupSupplier() throws Exception {
        Configuration config = new Configuration();
        TraceOptions.forReporter((Configuration)config, (String)"reporter1").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporter1.class.getName());
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        TraceReporterSetup reporterSetup = (TraceReporterSetup)reporterSetups.get(0);
        Assert.assertThat((Object)((TraceReporter)reporterSetup.getReporter()), (Matcher)IsInstanceOf.instanceOf(TestTraceReporter1.class));
    }

    @Test
    void testMultipleReporterInstantiation() throws Exception {
        Configuration config = new Configuration();
        TraceOptions.forReporter((Configuration)config, (String)"test1").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporter11.class.getName());
        TraceOptions.forReporter((Configuration)config, (String)"test2").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporter12.class.getName());
        TraceOptions.forReporter((Configuration)config, (String)"test3").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporter13.class.getName());
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)3L, (long)reporterSetups.size());
        Assert.assertTrue((boolean)TestTraceReporter11.wasOpened);
        Assert.assertTrue((boolean)TestTraceReporter12.wasOpened);
        Assert.assertTrue((boolean)TestTraceReporter13.wasOpened);
    }

    private static void configureReporter1(Configuration config) {
        Configuration reporterConfig = TraceOptions.forReporter((Configuration)config, (String)"reporter1").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporter1.class.getName());
        reporterConfig.setString("arg1", "value1");
        reporterConfig.setString("arg2", "value2");
    }

    private static void assertTraceReporter1Configured(TraceReporterSetup setup) {
        Assert.assertEquals((Object)"reporter1", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", ""));
        Assert.assertEquals((Object)"value2", (Object)setup.getConfiguration().getString("arg2", ""));
        Assert.assertEquals((Object)TestTraceReporter1.class.getName(), (Object)setup.getConfiguration().getString(TraceOptions.REPORTER_FACTORY_CLASS.key(), null));
    }

    private static void configureReporter2(Configuration config) {
        Configuration reporterConfig = TraceOptions.forReporter((Configuration)config, (String)"reporter2").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporter2.class.getName());
        reporterConfig.setString("arg1", "value1");
        reporterConfig.setString("arg3", "value3");
    }

    private static void assertReporter2Configured(TraceReporterSetup setup) {
        Assert.assertEquals((Object)"reporter2", (Object)setup.getName());
        Assert.assertEquals((Object)"value1", (Object)setup.getConfiguration().getString("arg1", null));
        Assert.assertEquals((Object)"value3", (Object)setup.getConfiguration().getString("arg3", null));
        Assert.assertEquals((Object)TestTraceReporter2.class.getName(), (Object)setup.getConfiguration().getString(TraceOptions.REPORTER_FACTORY_CLASS.key(), null));
    }

    @Test
    void testVariableExclusionParsing() throws Exception {
        String excludedVariable1 = "foo";
        String excludedVariable2 = "foo";
        Configuration config = new Configuration();
        TraceOptions.forReporter((Configuration)config, (String)"test").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporterFactory.class.getName()).set(TraceOptions.REPORTER_EXCLUDED_VARIABLES, (Object)"foo;foo");
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        TraceReporterSetup reporterSetup = (TraceReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getExcludedVariables(), (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{ScopeFormat.asVariable((String)"foo"), ScopeFormat.asVariable((String)"foo")}));
    }

    @Test
    void testFactoryParsing() throws Exception {
        Configuration config = new Configuration();
        TraceOptions.forReporter((Configuration)config, (String)"test").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporterFactory.class.getName());
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        TraceReporterSetup reporterSetup = (TraceReporterSetup)reporterSetups.get(0);
        Assert.assertEquals((Object)TestTraceReporterFactory.REPORTER, (Object)reporterSetup.getReporter());
    }

    @Test
    void testFactoryFailureIsolation() throws Exception {
        Configuration config = new Configuration();
        config.setString("traces.reporter.test." + TraceOptions.REPORTER_FACTORY_CLASS.key(), TestTraceReporterFactory.class.getName());
        config.setString("traces.reporter.fail." + TraceOptions.REPORTER_FACTORY_CLASS.key(), FailingFactory.class.getName());
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
    }

    @Test
    void testFactoryArgumentForwarding() throws Exception {
        Configuration config = new Configuration();
        config.setString("traces.reporter.test." + TraceOptions.REPORTER_FACTORY_CLASS.key(), ConfigExposingReporterFactory.class.getName());
        config.setString("traces.reporter.test.arg", "hello");
        ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Properties passedConfig = ConfigExposingReporterFactory.lastConfig;
        Assert.assertEquals((Object)"hello", (Object)passedConfig.getProperty("arg"));
    }

    @Test
    void testAdditionalVariablesParsing() {
        String tag1 = "foo";
        String tagValue1 = "bar";
        String tag2 = "fizz";
        String tagValue2 = "buzz";
        Configuration config = new Configuration();
        TraceOptions.forReporter((Configuration)config, (String)"test").set(TraceOptions.REPORTER_FACTORY_CLASS, (Object)TestTraceReporterFactory.class.getName()).setString(TraceOptions.REPORTER_ADDITIONAL_VARIABLES.key(), String.join((CharSequence)",", "foo:bar", "fizz:buzz"));
        List reporterSetups = ReporterSetupBuilder.TRACE_SETUP_BUILDER.fromConfiguration(config, DefaultReporterFilters::tracesFromConfiguration, null);
        Assert.assertEquals((long)1L, (long)reporterSetups.size());
        TraceReporterSetup reporterSetup = (TraceReporterSetup)reporterSetups.get(0);
        MatcherAssert.assertThat((Object)reporterSetup.getAdditionalVariables(), (Matcher)IsMapContaining.hasEntry((Object)ScopeFormat.asVariable((String)"foo"), (Object)"bar"));
        MatcherAssert.assertThat((Object)reporterSetup.getAdditionalVariables(), (Matcher)IsMapContaining.hasEntry((Object)ScopeFormat.asVariable((String)"fizz"), (Object)"buzz"));
    }

    public static class FailingFactory
    implements TraceReporterFactory {
        public TraceReporter createTraceReporter(Properties config) {
            throw new RuntimeException();
        }
    }

    public static class TestTraceReporterFactory
    implements TraceReporterFactory {
        static final TraceReporter REPORTER = new TestTraceReporter();

        public TraceReporter createTraceReporter(Properties config) {
            return REPORTER;
        }
    }

    public static class ConfigExposingReporterFactory
    implements TraceReporterFactory {
        static Properties lastConfig = null;

        public TraceReporter createTraceReporter(Properties config) {
            lastConfig = config;
            return new TestTraceReporter();
        }
    }

    public static class TestTraceReporter13
    extends TestTraceReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestTraceReporter12
    extends TestTraceReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestTraceReporter11
    extends TestTraceReporter {
        public static boolean wasOpened = false;

        @Override
        public void open(MetricConfig config) {
            wasOpened = true;
        }
    }

    public static class TestTraceReporter2
    extends TestTraceReporter {
    }

    public static class TestTraceReporter1
    extends TestTraceReporter {
    }
}

