/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElection;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.TestingGenericLeaderContender;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StandaloneLeaderElectionTest {
    private static final UUID SESSION_ID = UUID.randomUUID();
    private static final String TEST_URL = "pekko://users/jobmanager";

    StandaloneLeaderElectionTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testStandaloneLeaderElectionRetrieval() throws Exception {
        UUID expectedSessionID = UUID.randomUUID();
        StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(TEST_URL, expectedSessionID);
        TestingListener testingListener = new TestingListener();
        try (StandaloneLeaderElection leaderElection = new StandaloneLeaderElection(expectedSessionID);){
            TestingContender contender = new TestingContender(TEST_URL, (LeaderElection)leaderElection);
            contender.startLeaderElection();
            leaderRetrievalService.start((LeaderRetrievalListener)testingListener);
            contender.waitForLeader();
            Assertions.assertThat((boolean)contender.isLeader()).isTrue();
            Assertions.assertThat((Comparable)contender.getLeaderSessionID()).isEqualTo((Object)expectedSessionID);
            testingListener.waitForNewLeader();
            Assertions.assertThat((String)testingListener.getAddress()).isEqualTo(TEST_URL);
            Assertions.assertThat((Comparable)testingListener.getLeaderSessionID()).isEqualTo((Object)expectedSessionID);
        }
        finally {
            leaderRetrievalService.stop();
        }
    }

    @Test
    void testStartLeaderElection() throws Exception {
        CompletableFuture grantLeadershipResult = new CompletableFuture();
        TestingGenericLeaderContender contender = TestingGenericLeaderContender.newBuilder().setGrantLeadershipConsumer(grantLeadershipResult::complete).build();
        try (StandaloneLeaderElection testInstance = new StandaloneLeaderElection(SESSION_ID);){
            testInstance.startLeaderElection((LeaderContender)contender);
            Assertions.assertThat(grantLeadershipResult).isCompletedWithValue((Object)SESSION_ID);
        }
    }

    @Test
    void testHasLeadershipAsyncWithContender() throws Exception {
        TestingGenericLeaderContender contender = TestingGenericLeaderContender.newBuilder().build();
        try (StandaloneLeaderElection testInstance = new StandaloneLeaderElection(SESSION_ID);){
            testInstance.startLeaderElection((LeaderContender)contender);
            FlinkAssertions.assertThatFuture((CompletableFuture)testInstance.hasLeadershipAsync(SESSION_ID)).eventuallySucceeds().isEqualTo((Object)true);
            UUID differentSessionID = UUID.randomUUID();
            FlinkAssertions.assertThatFuture((CompletableFuture)testInstance.hasLeadershipAsync(differentSessionID)).eventuallySucceeds().isEqualTo((Object)false);
        }
    }

    @Test
    void testHasLeadershipAsyncWithoutContender() throws Exception {
        try (StandaloneLeaderElection testInstance = new StandaloneLeaderElection(SESSION_ID);){
            FlinkAssertions.assertThatFuture((CompletableFuture)testInstance.hasLeadershipAsync(SESSION_ID)).eventuallySucceeds().isEqualTo((Object)false);
            UUID differentSessionID = UUID.randomUUID();
            FlinkAssertions.assertThatFuture((CompletableFuture)testInstance.hasLeadershipAsync(differentSessionID)).eventuallySucceeds().isEqualTo((Object)false);
        }
    }

    @Test
    void testRevokeCallOnClose() throws Exception {
        AtomicBoolean revokeLeadershipCalled = new AtomicBoolean(false);
        TestingGenericLeaderContender contender = TestingGenericLeaderContender.newBuilder().setRevokeLeadershipRunnable(() -> revokeLeadershipCalled.set(true)).build();
        try (StandaloneLeaderElection testInstance = new StandaloneLeaderElection(SESSION_ID);){
            testInstance.startLeaderElection((LeaderContender)contender);
        }
        Assertions.assertThat((AtomicBoolean)revokeLeadershipCalled).isTrue();
    }
}

