/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResult;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResultTest;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultLogicalVertexTest
extends TestLogger {
    private JobVertex upstreamJobVertex;
    private DefaultLogicalVertex upstreamLogicalVertex;
    private JobVertex downstreamJobVertex;
    private DefaultLogicalVertex downstreamLogicalVertex;
    private Map<IntermediateDataSetID, IntermediateDataSet> resultMap;
    private Set<IntermediateDataSet> results;

    @Before
    public void setUp() throws Exception {
        this.buildVerticesAndResults();
        this.upstreamLogicalVertex = new DefaultLogicalVertex(this.upstreamJobVertex, rid -> new DefaultLogicalResult(this.resultMap.get(rid), vid -> null));
        this.downstreamLogicalVertex = new DefaultLogicalVertex(this.downstreamJobVertex, rid -> new DefaultLogicalResult(this.resultMap.get(rid), vid -> null));
    }

    @Test
    public void testConstructor() {
        DefaultLogicalVertexTest.assertVertexInfoEquals(this.upstreamJobVertex, this.upstreamLogicalVertex);
        DefaultLogicalVertexTest.assertVertexInfoEquals(this.downstreamJobVertex, this.downstreamLogicalVertex);
    }

    @Test
    public void testGetConsumedResults() {
        DefaultLogicalResultTest.assertResultsEquals(this.results, this.downstreamLogicalVertex.getConsumedResults());
    }

    @Test
    public void testGetProducedResults() {
        DefaultLogicalResultTest.assertResultsEquals(this.results, this.upstreamLogicalVertex.getProducedResults());
    }

    private void buildVerticesAndResults() {
        this.resultMap = new HashMap<IntermediateDataSetID, IntermediateDataSet>();
        this.results = new HashSet<IntermediateDataSet>();
        int parallelism = 3;
        this.upstreamJobVertex = ExecutionGraphTestUtils.createNoOpVertex(3);
        this.downstreamJobVertex = ExecutionGraphTestUtils.createNoOpVertex(3);
        for (int i = 0; i < 5; ++i) {
            JobEdge edge = JobVertexConnectionUtils.connectNewDataSetAsInput(this.downstreamJobVertex, this.upstreamJobVertex, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
            IntermediateDataSet consumedDataSet = edge.getSource();
            this.results.add(consumedDataSet);
            this.resultMap.put(consumedDataSet.getId(), consumedDataSet);
        }
    }

    static void assertVerticesEquals(Iterable<JobVertex> jobVertices, Iterable<DefaultLogicalVertex> logicalVertices) {
        Map logicalVertextMap = IterableUtils.toStream(logicalVertices).collect(Collectors.toMap(DefaultLogicalVertex::getId, Function.identity()));
        for (JobVertex jobVertex : jobVertices) {
            DefaultLogicalVertex logicalVertex = (DefaultLogicalVertex)logicalVertextMap.remove(jobVertex.getID());
            Assert.assertNotNull((Object)logicalVertex);
            DefaultLogicalVertexTest.assertVertexInfoEquals(jobVertex, logicalVertex);
        }
        Assert.assertEquals((long)0L, (long)logicalVertextMap.size());
    }

    static void assertVertexInfoEquals(JobVertex jobVertex, DefaultLogicalVertex logicalVertex) {
        Assert.assertEquals((Object)jobVertex.getID(), (Object)logicalVertex.getId());
    }
}

