/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;

public class TestingPartitionRequestListener
implements PartitionRequestListener {
    private final long createTimestamp = System.currentTimeMillis();
    private final ResultPartitionID resultPartitionId;
    private final InputChannelID inputChannelId;
    private final NetworkSequenceViewReader reader;

    private TestingPartitionRequestListener(ResultPartitionID resultPartitionId, InputChannelID inputChannelId, NetworkSequenceViewReader reader) {
        this.resultPartitionId = resultPartitionId;
        this.inputChannelId = inputChannelId;
        this.reader = reader;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public ResultPartitionID getResultPartitionId() {
        return this.resultPartitionId;
    }

    public NetworkSequenceViewReader getViewReader() {
        return this.reader;
    }

    public InputChannelID getReceiverId() {
        return this.inputChannelId;
    }

    public void notifyPartitionCreated(ResultPartition partition) throws IOException {
        this.reader.notifySubpartitionsCreated(partition, new ResultSubpartitionIndexSet(0));
    }

    public void notifyPartitionCreatedTimeout() {
    }

    public void releaseListener() {
    }

    public static TestingPartitionRequestListenerBuilder newBuilder() {
        return new TestingPartitionRequestListenerBuilder();
    }

    public static class TestingPartitionRequestListenerBuilder {
        private ResultPartitionID resultPartitionId = new ResultPartitionID();
        private InputChannelID inputChannelId = new InputChannelID();
        private NetworkSequenceViewReader reader = null;

        public TestingPartitionRequestListenerBuilder setResultPartitionId(ResultPartitionID resultPartitionId) {
            this.resultPartitionId = resultPartitionId;
            return this;
        }

        public TestingPartitionRequestListenerBuilder setInputChannelId(InputChannelID inputChannelId) {
            this.inputChannelId = inputChannelId;
            return this;
        }

        public TestingPartitionRequestListenerBuilder setNetworkSequenceViewReader(NetworkSequenceViewReader reader) {
            this.reader = reader;
            return this;
        }

        public TestingPartitionRequestListener build() {
            return new TestingPartitionRequestListener(this.resultPartitionId, this.inputChannelId, this.reader);
        }
    }
}

