/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.NoOpFileChannelManager;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironmentBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.BufferWritingResultPartition;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.PipelinedApproximateSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionTest;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class PipelinedApproximateSubpartitionTest
extends PipelinedSubpartitionTest {
    private static final int BUFFER_SIZE = 16;

    PipelinedApproximateSubpartitionTest() {
    }

    @Override
    PipelinedSubpartition createSubpartition() throws Exception {
        return PipelinedApproximateSubpartitionTest.createPipelinedApproximateSubpartition();
    }

    @Override
    @TestTemplate
    void testIllegalReadViewRequest() {
    }

    @TestTemplate
    void testRecreateReadView() throws Exception {
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.createPipelinedApproximateSubpartition();
        Assertions.assertThat((Object)subpartition.createReadView(view -> {})).isNotNull();
        Assertions.assertThat((boolean)subpartition.isPartialBufferCleanupRequired()).isFalse();
        Assertions.assertThat((Object)subpartition.createReadView(view -> {})).isNotNull();
        Assertions.assertThat((boolean)subpartition.isPartialBufferCleanupRequired()).isTrue();
    }

    @TestTemplate
    void testSkipPartialDataEndsInBufferWithNoMoreData() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 42), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        Assertions.assertThat((Object)subpartition.pollBuffer()).isNull();
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(8, 9), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 8, 9);
    }

    @TestTemplate
    void testSkipPartialDataEndsInBufferWithMoreData() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 42), 0);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(8, 9), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 8, 9);
    }

    @TestTemplate
    void testSkipPartialDataStartWithFullRecord() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 42), 0);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(8, 9), 0);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 42, 8, 9);
    }

    @TestTemplate
    void testSkipPartialDataStartWithinBuffer() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 42), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 42);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(8, 9), 0);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(10, 11), 0);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 8, 9, 10);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 11);
    }

    @TestTemplate
    void testSkipPartialDataLongRecordOccupyEntireBuffer() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 8, 42), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        Assertions.assertThat((Object)subpartition.pollBuffer()).isNull();
    }

    @TestTemplate
    void testSkipPartialDataLongRecordOccupyEntireBufferWithMoreData() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 7, 8, 42), 0);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(100, 101, 102), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 100, 101);
        subpartition.setIsPartialBufferCleanupRequired();
        Assertions.assertThat((Object)subpartition.pollBuffer()).isNull();
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(200, 201, 202, 203), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 200, 201, 202);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 203);
    }

    @TestTemplate
    void testSkipPartialDataLongRecordEndWithBuffer() throws Exception {
        BufferWritingResultPartition writer = PipelinedApproximateSubpartitionTest.createResultPartition();
        PipelinedApproximateSubpartition subpartition = PipelinedApproximateSubpartitionTest.getPipelinedApproximateSubpartition(writer);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(0, 1, 2, 3, 4, 5, 6, 42), 0);
        writer.emitRecord(BufferBuilderTestUtils.toByteBuffer(100, 101, 102), 0);
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 0, 1, 2, 3);
        subpartition.setIsPartialBufferCleanupRequired();
        BufferBuilderTestUtils.assertContent(Objects.requireNonNull(subpartition.pollBuffer()).buffer(), null, 100, 101, 102);
    }

    private static PipelinedApproximateSubpartition createPipelinedApproximateSubpartition() throws IOException {
        BufferWritingResultPartition parent = PipelinedApproximateSubpartitionTest.createResultPartition();
        return (PipelinedApproximateSubpartition)parent.subpartitions[0];
    }

    private static PipelinedApproximateSubpartition getPipelinedApproximateSubpartition(BufferWritingResultPartition resultPartition) {
        return (PipelinedApproximateSubpartition)resultPartition.subpartitions[0];
    }

    private static BufferWritingResultPartition createResultPartition() throws IOException {
        NettyShuffleEnvironment network = new NettyShuffleEnvironmentBuilder().setNumNetworkBuffers(10).setBufferSize(16).build();
        ResultPartition resultPartition = PartitionTestUtils.createPartition(network, (FileChannelManager)NoOpFileChannelManager.INSTANCE, ResultPartitionType.PIPELINED_APPROXIMATE, 2);
        resultPartition.setup();
        return (BufferWritingResultPartition)resultPartition;
    }
}

