/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleTestUtils;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class ShuffleDescriptorTest {
    ShuffleDescriptorTest() {
    }

    @Test
    void testMixedLocalRemoteUnknownDeployment() throws Exception {
        ResourceID consumerResourceID = ResourceID.generate();
        JobID jobID = new JobID();
        for (ExecutionState state : ExecutionState.values()) {
            ResultPartitionID localPartitionId = new ResultPartitionID();
            ResultPartitionDeploymentDescriptor localPartition = ShuffleDescriptorTest.createResultPartitionDeploymentDescriptor(jobID, localPartitionId, consumerResourceID);
            ResultPartitionID remotePartitionId = new ResultPartitionID();
            ResourceID remoteResourceID = ResourceID.generate();
            ResultPartitionDeploymentDescriptor remotePartition = ShuffleDescriptorTest.createResultPartitionDeploymentDescriptor(jobID, remotePartitionId, remoteResourceID);
            ResultPartitionID unknownPartitionId = new ResultPartitionID();
            ShuffleDescriptor localShuffleDescriptor = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(localPartitionId, state, localPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
            ShuffleDescriptor remoteShuffleDescriptor = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(remotePartitionId, state, remotePartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
            ShuffleDescriptor unknownShuffleDescriptor = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, state, null, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
            if (state == ExecutionState.RUNNING || state == ExecutionState.INITIALIZING || state == ExecutionState.FINISHED || state == ExecutionState.SCHEDULED || state == ExecutionState.DEPLOYING) {
                ShuffleDescriptorTest.verifyShuffleDescriptor(localShuffleDescriptor, NettyShuffleDescriptor.class, false, localPartitionId);
                NettyShuffleDescriptor nettyShuffleDescriptor = (NettyShuffleDescriptor)localShuffleDescriptor;
                Assertions.assertThat((boolean)nettyShuffleDescriptor.isLocalTo(consumerResourceID)).isTrue();
                ShuffleDescriptorTest.verifyShuffleDescriptor(remoteShuffleDescriptor, NettyShuffleDescriptor.class, false, remotePartitionId);
                nettyShuffleDescriptor = (NettyShuffleDescriptor)remoteShuffleDescriptor;
                Assertions.assertThat((boolean)nettyShuffleDescriptor.isLocalTo(consumerResourceID)).isFalse();
                Assertions.assertThat((Object)nettyShuffleDescriptor.getConnectionId().getAddress()).isEqualTo((Object)InputChannelBuilder.STUB_CONNECTION_ID.getAddress());
                Assertions.assertThat((int)nettyShuffleDescriptor.getConnectionId().getConnectionIndex()).isEqualTo(InputChannelBuilder.STUB_CONNECTION_ID.getConnectionIndex());
                Assertions.assertThat((Object)nettyShuffleDescriptor.getConnectionId().getResourceID()).isEqualTo((Object)remoteResourceID);
            } else {
                ShuffleDescriptorTest.verifyShuffleDescriptor(localShuffleDescriptor, UnknownShuffleDescriptor.class, true, localPartitionId);
                ShuffleDescriptorTest.verifyShuffleDescriptor(remoteShuffleDescriptor, UnknownShuffleDescriptor.class, true, remotePartitionId);
            }
            ShuffleDescriptorTest.verifyShuffleDescriptor(unknownShuffleDescriptor, UnknownShuffleDescriptor.class, true, unknownPartitionId);
        }
    }

    private static void verifyShuffleDescriptor(ShuffleDescriptor descriptor, Class<? extends ShuffleDescriptor> cl, boolean unknown, ResultPartitionID partitionID) {
        Assertions.assertThat((Object)descriptor).isInstanceOf(cl);
        Assertions.assertThat((boolean)descriptor.isUnknown()).isEqualTo(unknown);
        Assertions.assertThat((Object)descriptor.getResultPartitionID()).isEqualTo((Object)partitionID);
    }

    @Test
    void testNonFinishedHybridPartitionShouldBeUnknown() throws Exception {
        ResultPartitionID unknownPartitionId = new ResultPartitionID();
        ResultPartitionID partitionID = new ResultPartitionID();
        ResourceID remoteResourceID = ResourceID.generate();
        JobID jobID = new JobID();
        ResultPartitionDeploymentDescriptor producerPartition = ShuffleDescriptorTest.createResultPartitionDeploymentDescriptor(jobID, partitionID, remoteResourceID);
        ShuffleDescriptor unknownSdd = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, ExecutionState.DEPLOYING, ResultPartitionType.HYBRID_FULL, producerPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN, true);
        Assertions.assertThat((Object)unknownSdd).isInstanceOf(UnknownShuffleDescriptor.class);
        Assertions.assertThat((boolean)unknownSdd.isUnknown()).isTrue();
        Assertions.assertThat((Object)unknownSdd.getResultPartitionID()).isEqualTo((Object)unknownPartitionId);
        Assertions.assertThatThrownBy(() -> ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, ExecutionState.DEPLOYING, ResultPartitionType.HYBRID_FULL, producerPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.MUST_BE_KNOWN, true)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testUnknownDescriptorWithOrWithoutLazyDeployment() {
        ResultPartitionID unknownPartitionId = new ResultPartitionID();
        ShuffleDescriptor unknownSdd = ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, ExecutionState.CREATED, null, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.CAN_BE_UNKNOWN);
        Assertions.assertThat((Object)unknownSdd).isInstanceOf(UnknownShuffleDescriptor.class);
        Assertions.assertThat((boolean)unknownSdd.isUnknown()).isTrue();
        Assertions.assertThat((Object)unknownSdd.getResultPartitionID()).isEqualTo((Object)unknownPartitionId);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(unknownPartitionId, ExecutionState.CREATED, null, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.MUST_BE_KNOWN)).withFailMessage("Did not throw expected ExecutionGraphException", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    private static ShuffleDescriptor getConsumedPartitionShuffleDescriptor(ResultPartitionID id, ExecutionState state, @Nullable ResultPartitionDeploymentDescriptor producedPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint partitionLocationConstraint) {
        return ShuffleDescriptorTest.getConsumedPartitionShuffleDescriptor(id, state, ResultPartitionType.PIPELINED, producedPartition, partitionLocationConstraint, false);
    }

    private static ShuffleDescriptor getConsumedPartitionShuffleDescriptor(ResultPartitionID id, ExecutionState state, ResultPartitionType resultPartitionType, @Nullable ResultPartitionDeploymentDescriptor producedPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint partitionLocationConstraint, boolean nonFinishedHybridPartitionShouldBeUnknown) {
        ShuffleDescriptor shuffleDescriptor = TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor((ResultPartitionID)id, (ResultPartitionType)resultPartitionType, (boolean)true, (ExecutionState)state, (TaskDeploymentDescriptorFactory.PartitionLocationConstraint)partitionLocationConstraint, (ResultPartitionDeploymentDescriptor)producedPartition, (boolean)nonFinishedHybridPartitionShouldBeUnknown);
        Assertions.assertThat((Object)shuffleDescriptor).isNotNull();
        Assertions.assertThat((Object)shuffleDescriptor.getResultPartitionID()).isEqualTo((Object)id);
        return shuffleDescriptor;
    }

    private static ResultPartitionDeploymentDescriptor createResultPartitionDeploymentDescriptor(JobID jobID, ResultPartitionID id, ResourceID location) throws ExecutionException, InterruptedException {
        ProducerDescriptor producerDescriptor = new ProducerDescriptor(location, id.getProducerId(), InputChannelBuilder.STUB_CONNECTION_ID.getAddress().getAddress(), InputChannelBuilder.STUB_CONNECTION_ID.getAddress().getPort());
        PartitionDescriptor partitionDescriptor = PartitionDescriptorBuilder.newBuilder().setPartitionId(id.getPartitionId()).build();
        ShuffleDescriptor shuffleDescriptor = (ShuffleDescriptor)ShuffleTestUtils.DEFAULT_SHUFFLE_MASTER.registerPartitionWithProducer(jobID, partitionDescriptor, producerDescriptor).get();
        return new ResultPartitionDeploymentDescriptor(partitionDescriptor, shuffleDescriptor, 1);
    }
}

