/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.util.HashSet;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptor;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.apache.flink.runtime.checkpoint.channel.RecoveredChannelStateHandler;
import org.apache.flink.runtime.checkpoint.channel.RecoveredChannelStateHandlerTest;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionRecoveredStateHandler;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ResultSubpartitionRecoveredStateHandlerTest
extends RecoveredChannelStateHandlerTest {
    private static final int preAllocatedSegments = 3;
    private NetworkBufferPool networkBufferPool;
    private ResultPartition partition;
    private ResultSubpartitionRecoveredStateHandler rstHandler;
    private ResultSubpartitionInfo channelInfo;

    ResultSubpartitionRecoveredStateHandlerTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.channelInfo = new ResultSubpartitionInfo(0, 0);
        this.networkBufferPool = new NetworkBufferPool(3, 1024);
        this.partition = new ResultPartitionBuilder().setNetworkBufferPool(this.networkBufferPool).build();
        this.partition.setup();
        this.rstHandler = this.buildResultStateHandler(this.partition);
    }

    private ResultSubpartitionRecoveredStateHandler buildResultStateHandler(ResultPartition partition) {
        return new ResultSubpartitionRecoveredStateHandler(new ResultPartitionWriter[]{partition}, false, new InflightDataRescalingDescriptor(new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor[]{new InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor(new int[]{1}, RescaleMappings.identity((int)1, (int)1), new HashSet(), InflightDataRescalingDescriptor.InflightDataGateOrPartitionRescalingDescriptor.MappingType.IDENTITY)}));
    }

    @Override
    @Test
    void testRecycleBufferBeforeRecoverWasCalled() throws Exception {
        RecoveredChannelStateHandler.BufferWithContext bufferWithContext = this.rstHandler.getBuffer(new ResultSubpartitionInfo(0, 0));
        bufferWithContext.buffer.close();
        this.partition.close();
        Assertions.assertThat((int)this.networkBufferPool.getNumberOfAvailableMemorySegments()).isEqualTo(3);
    }

    @Override
    @Test
    void testRecycleBufferAfterRecoverWasCalled() throws Exception {
        RecoveredChannelStateHandler.BufferWithContext bufferWithContext = this.rstHandler.getBuffer(this.channelInfo);
        this.rstHandler.recover(this.channelInfo, 0, bufferWithContext);
        this.partition.close();
        Assertions.assertThat((int)this.networkBufferPool.getNumberOfAvailableMemorySegments()).isEqualTo(3);
    }
}

