/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.Preconditions;

@Internal
public class PartitionTransformation<T>
extends Transformation<T> {
    private final Transformation<T> input;
    private final StreamPartitioner<T> partitioner;
    private final StreamExchangeMode exchangeMode;

    public PartitionTransformation(Transformation<T> input, StreamPartitioner<T> partitioner) {
        this(input, partitioner, StreamExchangeMode.UNDEFINED);
    }

    public PartitionTransformation(Transformation<T> input, StreamPartitioner<T> partitioner, StreamExchangeMode exchangeMode) {
        super("Partition", input.getOutputType(), input.getParallelism());
        this.input = input;
        this.partitioner = partitioner;
        this.exchangeMode = (StreamExchangeMode)((Object)Preconditions.checkNotNull((Object)((Object)exchangeMode)));
    }

    public StreamPartitioner<T> getPartitioner() {
        return this.partitioner;
    }

    public StreamExchangeMode getExchangeMode() {
        return this.exchangeMode;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }
}

