/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;

@PublicEvolving
public class BroadcastStream<T> {
    private final StreamExecutionEnvironment environment;
    private final DataStream<T> inputStream;
    private final List<MapStateDescriptor<?, ?>> broadcastStateDescriptors;

    protected BroadcastStream(StreamExecutionEnvironment env, DataStream<T> input, MapStateDescriptor<?, ?> ... broadcastStateDescriptors) {
        this.environment = Objects.requireNonNull(env);
        this.inputStream = Objects.requireNonNull(input);
        this.broadcastStateDescriptors = Arrays.asList(Objects.requireNonNull(broadcastStateDescriptors));
    }

    public TypeInformation<T> getType() {
        return this.inputStream.getType();
    }

    public <F> F clean(F f) {
        return this.environment.clean(f);
    }

    public Transformation<T> getTransformation() {
        return this.inputStream.getTransformation();
    }

    public List<MapStateDescriptor<?, ?>> getBroadcastStateDescriptors() {
        return this.broadcastStateDescriptors;
    }

    public StreamExecutionEnvironment getEnvironment() {
        return this.environment;
    }
}

