/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.runtime.state.v2.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class RegisteredKeyAndUserKeyValueStateBackendMetaInfo<N, UK, S>
extends RegisteredKeyValueStateBackendMetaInfo<N, S> {
    @Nullable
    private StateSerializerProvider<UK> userKeySerializerProvider;

    public RegisteredKeyAndUserKeyValueStateBackendMetaInfo(@Nonnull String name, @Nonnull StateDescriptor.Type stateType, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer, @Nullable TypeSerializer<UK> userKeySerializer) {
        this(name, stateType, StateSerializerProvider.fromNewRegisteredSerializer(namespaceSerializer), StateSerializerProvider.fromNewRegisteredSerializer(stateSerializer), userKeySerializer == null ? null : StateSerializerProvider.fromNewRegisteredSerializer(userKeySerializer), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
    }

    public RegisteredKeyAndUserKeyValueStateBackendMetaInfo(@Nonnull StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), StateDescriptor.Type.valueOf((String)snapshot.getOption(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE)), StateSerializerProvider.fromPreviousSerializerSnapshot((TypeSerializerSnapshot)Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER))), StateSerializerProvider.fromPreviousSerializerSnapshot((TypeSerializerSnapshot)Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER))), snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.USER_KEY_SERIALIZER) == null ? null : StateSerializerProvider.fromPreviousSerializerSnapshot((TypeSerializerSnapshot)Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.USER_KEY_SERIALIZER))), StateSnapshotTransformer.StateSnapshotTransformFactory.noTransform());
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2 == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    public RegisteredKeyAndUserKeyValueStateBackendMetaInfo(@Nonnull String name, @Nonnull StateDescriptor.Type stateType, @Nonnull StateSerializerProvider<N> namespaceSerializerProvider, @Nonnull StateSerializerProvider<S> stateSerializerProvider, @Nullable StateSerializerProvider<UK> userKeySerializerProvider, @Nonnull StateSnapshotTransformer.StateSnapshotTransformFactory<S> stateSnapshotTransformFactory) {
        super(name, stateType, namespaceSerializerProvider, stateSerializerProvider, stateSnapshotTransformFactory);
        this.userKeySerializerProvider = userKeySerializerProvider;
    }

    @Nullable
    public TypeSerializer<UK> getUserKeySerializer() {
        return this.userKeySerializerProvider == null ? null : this.userKeySerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<UK> updateUserKeySerializer(TypeSerializer<UK> newStateSerializer) {
        if (this.userKeySerializerProvider == null) {
            this.userKeySerializerProvider = StateSerializerProvider.fromNewRegisteredSerializer(newStateSerializer);
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        return this.userKeySerializerProvider.registerNewSerializerForRestoredState(newStateSerializer);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof RegisteredKeyAndUserKeyValueStateBackendMetaInfo && Objects.equals(this.getUserKeySerializer(), ((RegisteredKeyAndUserKeyValueStateBackendMetaInfo)o).getUserKeySerializer());
    }

    @Override
    public String toString() {
        return "RegisteredKeyAndUserKeyValueStateBackendMetaInfo{stateType=" + this.stateType + ", name='" + this.name + "', namespaceSerializer=" + this.getNamespaceSerializer() + ", stateSerializer=" + this.getStateSerializer() + ", userKeySerializer=" + this.getUserKeySerializer() + "}";
    }

    @Override
    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getStateType().hashCode();
        result = 31 * result + this.getNamespaceSerializer().hashCode();
        result = 31 * result + this.getStateSerializer().hashCode();
        if (this.getUserKeySerializer() != null) {
            result = 31 * result + this.getUserKeySerializer().hashCode();
        }
        return result;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Override
    @Nonnull
    public RegisteredKeyAndUserKeyValueStateBackendMetaInfo<N, UK, S> withSerializerUpgradesAllowed() {
        return new RegisteredKeyAndUserKeyValueStateBackendMetaInfo<N, UK, S>(this.snapshot());
    }

    @Nonnull
    private StateMetaInfoSnapshot computeSnapshot() {
        Map<String, String> optionsMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonOptionsKeys.KEYED_STATE_TYPE.toString(), this.stateType.toString());
        HashMap serializerMap = CollectionUtil.newHashMapWithExpectedSize((int)2);
        HashMap serializerConfigSnapshotsMap = CollectionUtil.newHashMapWithExpectedSize((int)2);
        String namespaceSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.NAMESPACE_SERIALIZER.toString();
        String valueSerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString();
        TypeSerializer namespaceSerializer = this.getNamespaceSerializer();
        serializerMap.put(namespaceSerializerKey, namespaceSerializer.duplicate());
        serializerConfigSnapshotsMap.put(namespaceSerializerKey, namespaceSerializer.snapshotConfiguration());
        TypeSerializer stateSerializer = this.getStateSerializer();
        serializerMap.put(valueSerializerKey, stateSerializer.duplicate());
        serializerConfigSnapshotsMap.put(valueSerializerKey, stateSerializer.snapshotConfiguration());
        TypeSerializer<UK> userKeySerializer = this.getUserKeySerializer();
        if (userKeySerializer != null) {
            String userKeySerializerKey = StateMetaInfoSnapshot.CommonSerializerKeys.USER_KEY_SERIALIZER.toString();
            serializerMap.put(userKeySerializerKey, userKeySerializer.duplicate());
            serializerConfigSnapshotsMap.put(userKeySerializerKey, userKeySerializer.snapshotConfiguration());
        }
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.KEY_VALUE_V2, optionsMap, serializerConfigSnapshotsMap, serializerMap);
    }
}

