/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.Preconditions;

public class JobPlanInfo
implements ResponseBody {
    private static final String FIELD_NAME_PLAN = "plan";
    @JsonProperty(value="plan")
    private final Plan plan;

    @JsonCreator
    public JobPlanInfo(@JsonProperty(value="plan") Plan plan) {
        this.plan = plan;
    }

    @JsonIgnore
    public Plan getPlan() {
        return this.plan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPlanInfo that = (JobPlanInfo)o;
        return Objects.equals(this.plan, that.plan);
    }

    public int hashCode() {
        return Objects.hash(this.plan);
    }

    public String toString() {
        return "JobPlanInfo{plan=" + this.plan + "}";
    }

    @Schema(name="Plan")
    public static final class Plan
    implements Serializable {
        private static final String FIELD_NAME_JOB_ID = "jid";
        @JsonProperty(value="jid")
        private final String jobId;
        private static final String FIELD_NAME_NAME = "name";
        @JsonProperty(value="name")
        private final String name;
        private static final String FIELD_NAME_TYPE = "type";
        @JsonProperty(value="type")
        private final String type;
        private static final String FIELD_NAME_NODES = "nodes";
        @JsonProperty(value="nodes")
        private final Collection<Node> nodes;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plan that = (Plan)o;
            return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.nodes, that.nodes);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.name, this.type, this.nodes);
        }

        @JsonCreator
        public Plan(@JsonProperty(value="jid") String jobId, @JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="nodes") Collection<Node> nodes) {
            this.jobId = (String)Preconditions.checkNotNull((Object)jobId);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.type = (String)Preconditions.checkNotNull((Object)type);
            this.nodes = (Collection)Preconditions.checkNotNull(nodes);
        }

        @JsonIgnore
        public String getJobId() {
            return this.jobId;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        @JsonIgnore
        public String getType() {
            return this.type;
        }

        @JsonIgnore
        public Collection<Node> getNodes() {
            return this.nodes;
        }

        @Schema(name="PlanNode")
        public static final class Node
        implements Serializable {
            private static final String FIELD_NAME_ID = "id";
            @JsonProperty(value="id")
            private final String id;
            private static final String FIELD_NAME_PARALLELISM = "parallelism";
            @JsonProperty(value="parallelism")
            private final long parallelism;
            private static final String FIELD_NAME_OPERATOR = "operator";
            @JsonProperty(value="operator")
            private final String operator;
            private static final String FIELD_NAME_OPERATOR_STRATEGY = "operator_strategy";
            @JsonProperty(value="operator_strategy")
            private final String operatorStrategy;
            private static final String FIELD_NAME_DESCRIPTION = "description";
            @JsonProperty(value="description")
            private final String description;
            private static final String FIELD_NAME_OPTIMIZER_PROPERTIES = "optimizer_properties";
            @JsonProperty(value="optimizer_properties")
            @JsonSerialize(using=RawJson.Serializer.class)
            private final RawJson optimizerProperties;
            private static final String FIELD_NAME_INPUTS = "inputs";
            @Nullable
            @JsonProperty(value="inputs")
            @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
            private final Collection<Input> inputs;

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Node that = (Node)o;
                return Objects.equals(this.id, that.id) && Objects.equals(this.operator, that.operator) && Objects.equals(this.operatorStrategy, that.operatorStrategy) && Objects.equals(this.description, that.description) && Objects.equals(this.optimizerProperties, that.optimizerProperties) && Objects.equals(this.inputs, that.inputs) && this.parallelism == that.parallelism;
            }

            public int hashCode() {
                return Objects.hash(this.id, this.operator, this.parallelism, this.operatorStrategy, this.description, this.optimizerProperties, this.inputs);
            }

            @JsonCreator
            public Node(@JsonProperty(value="id") String id, @JsonProperty(value="operator") String operator, @JsonProperty(value="parallelism") long parallelism, @JsonProperty(value="operator_strategy") String operatorStrategy, @JsonProperty(value="description") String description, @JsonProperty(value="optimizer_properties") @JsonDeserialize(using=RawJson.Deserializer.class) RawJson optimizerProperties, @Nullable @JsonProperty(value="inputs") Collection<Input> inputs) {
                this.id = (String)Preconditions.checkNotNull((Object)id);
                this.operator = (String)Preconditions.checkNotNull((Object)operator);
                this.parallelism = (Long)Preconditions.checkNotNull((Object)parallelism);
                this.operatorStrategy = (String)Preconditions.checkNotNull((Object)operatorStrategy);
                this.description = (String)Preconditions.checkNotNull((Object)description);
                this.optimizerProperties = (RawJson)Preconditions.checkNotNull((Object)optimizerProperties);
                this.inputs = inputs;
            }

            @JsonIgnore
            public String getId() {
                return this.id;
            }

            @JsonIgnore
            public long getParallelism() {
                return this.parallelism;
            }

            @JsonIgnore
            public String getOperator() {
                return this.operator;
            }

            @JsonIgnore
            public String getOperatorStrategy() {
                return this.operatorStrategy;
            }

            @JsonIgnore
            public String getDescription() {
                return this.description;
            }

            @JsonIgnore
            public RawJson getOptimizerProperties() {
                return this.optimizerProperties;
            }

            @JsonIgnore
            public Collection<Input> getInputs() {
                return this.inputs;
            }

            @Schema(name="Input")
            public static final class Input
            implements Serializable {
                private static final String FIELD_NAME_NUM = "num";
                @JsonProperty(value="num")
                private final long num;
                private static final String FIELD_NAME_ID = "id";
                @JsonProperty(value="id")
                private final String id;
                private static final String FIELD_NAME_SHIP_STRATEGY = "ship_strategy";
                @Nullable
                @JsonProperty(value="ship_strategy")
                private final String shipStrategy;
                private static final String FIELD_NAME_LOCAL_STRATEGY = "local_strategy";
                @Nullable
                @JsonInclude(value=JsonInclude.Include.NON_NULL)
                @JsonProperty(value="local_strategy")
                private final String localStrategy;
                private static final String FIELD_NAME_CACHING = "caching";
                @Nullable
                @JsonInclude(value=JsonInclude.Include.NON_NULL)
                @JsonProperty(value="caching")
                private final String caching;
                private static final String FIELD_NAME_EXCHANGE = "exchange";
                @JsonProperty(value="exchange")
                private final String exchange;

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    Input that = (Input)o;
                    return Objects.equals(this.id, that.id) && this.num == that.num && Objects.equals(this.shipStrategy, that.shipStrategy) && Objects.equals(this.localStrategy, that.localStrategy) && Objects.equals(this.caching, that.caching) && Objects.equals(this.exchange, that.exchange);
                }

                public int hashCode() {
                    return Objects.hash(this.id, this.num, this.shipStrategy, this.localStrategy, this.caching, this.exchange);
                }

                @JsonCreator
                public Input(@JsonProperty(value="id") String id, @JsonProperty(value="num") long num, @JsonProperty(value="exchange") String exchange, @Nullable @JsonProperty(value="ship_strategy") String shipStrategy, @Nullable @JsonProperty(value="local_strategy") String localStrategy, @Nullable @JsonProperty(value="caching") String caching) {
                    this.id = (String)Preconditions.checkNotNull((Object)id);
                    this.num = (Long)Preconditions.checkNotNull((Object)num);
                    this.exchange = (String)Preconditions.checkNotNull((Object)exchange);
                    this.shipStrategy = shipStrategy;
                    this.localStrategy = localStrategy;
                    this.caching = caching;
                }

                @JsonIgnore
                public long getNum() {
                    return this.num;
                }

                @JsonIgnore
                public String getId() {
                    return this.id;
                }

                @JsonIgnore
                public String getShipStrategy() {
                    return this.shipStrategy;
                }

                @JsonIgnore
                public String getLocalStrategy() {
                    return this.localStrategy;
                }

                @JsonIgnore
                public String getCaching() {
                    return this.caching;
                }

                @JsonIgnore
                public String getExchange() {
                    return this.exchange;
                }
            }
        }
    }

    @JsonSerialize(using=Serializer.class)
    @JsonDeserialize(using=Deserializer.class)
    public static final class RawJson
    implements Serializable {
        private final String json;

        public RawJson(String json) {
            this.json = json;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawJson rawJson = (RawJson)o;
            return Objects.equals(this.json, rawJson.json);
        }

        public int hashCode() {
            return Objects.hash(this.json);
        }

        public String toString() {
            return "RawJson{json='" + this.json + "'}";
        }

        public static final class Deserializer
        extends StdDeserializer<RawJson> {
            private static final long serialVersionUID = -3580088509877177213L;

            public Deserializer() {
                super(RawJson.class);
            }

            public RawJson deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
                return new RawJson(rootNode.toString());
            }
        }

        public static final class Serializer
        extends StdSerializer<RawJson> {
            private static final long serialVersionUID = -1551666039618928811L;

            public Serializer() {
                super(RawJson.class);
            }

            public void serialize(RawJson jobPlanInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeRawValue(jobPlanInfo.json);
            }

            public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
                visitor.expectObjectFormat(typeHint);
            }
        }
    }
}

