/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.checkpoints;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.NotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;
import org.apache.flink.util.ExceptionUtils;

@Internal
public abstract class AbstractCheckpointStatsHandler<R extends ResponseBody, M extends JobMessageParameters>
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, R, M> {
    private final Executor executor;
    private final Cache<JobID, CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotCache;

    protected AbstractCheckpointStatsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, R, M> messageHeaders, Cache<JobID, CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.executor = executor;
        this.checkpointStatsSnapshotCache = checkpointStatsSnapshotCache;
    }

    @Override
    protected CompletableFuture<R> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        try {
            return ((CompletableFuture)((CompletableFuture)this.checkpointStatsSnapshotCache.get((Object)jobId, () -> gateway.requestCheckpointStats(jobId, this.timeout))).thenApplyAsync(checkpointStatsSnapshot -> {
                try {
                    return this.handleCheckpointStatsRequest(request, (CheckpointStatsSnapshot)checkpointStatsSnapshot);
                }
                catch (RestHandlerException e) {
                    throw new CompletionException((Throwable)((Object)e));
                }
            }, this.executor)).exceptionally(throwable -> {
                if ((throwable = ExceptionUtils.stripCompletionException((Throwable)throwable)) instanceof FlinkJobNotFoundException) {
                    throw new CompletionException((Throwable)((Object)new NotFoundException(String.format("Job %s not found", jobId), (Throwable)throwable)));
                }
                throw new CompletionException((Throwable)throwable);
            });
        }
        catch (ExecutionException e) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e);
            return future;
        }
    }

    protected abstract R handleCheckpointStatsRequest(HandlerRequest<EmptyRequestBody> var1, CheckpointStatsSnapshot var2) throws RestHandlerException;
}

