/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.rest.handler.util.HandlerRedirectUtils;
import org.apache.flink.runtime.rest.handler.util.KeepAliveWrite;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.shaded.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectingSslHandler
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(RedirectingSslHandler.class);
    private static final String SSL_HANDLER_NAME = "ssl";
    private static final String HTTP_CODEC_HANDLER_NAME = "http-codec";
    private static final String NON_SSL_HANDLER_NAME = "redirecting-non-ssl";
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    @Nonnull
    private final String confRedirectBaseUrl;
    @Nonnull
    private final CompletableFuture<String> redirectBaseUrl;
    @Nonnull
    private final SSLHandlerFactory sslHandlerFactory;

    public RedirectingSslHandler(@Nonnull String confRedirectHost, @Nonnull CompletableFuture<String> redirectBaseUrl, @Nonnull SSLHandlerFactory sslHandlerFactory) {
        this.confRedirectBaseUrl = "https://" + confRedirectHost + ":";
        this.redirectBaseUrl = redirectBaseUrl;
        this.sslHandlerFactory = sslHandlerFactory;
    }

    protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
        if (in.readableBytes() >= 5 && SslHandler.isEncrypted((ByteBuf)in)) {
            this.handleSsl(context);
        } else {
            context.pipeline().replace((ChannelHandler)this, HTTP_CODEC_HANDLER_NAME, (ChannelHandler)new HttpServerCodec());
            context.pipeline().addAfter(HTTP_CODEC_HANDLER_NAME, NON_SSL_HANDLER_NAME, (ChannelHandler)new NonSslHandler());
        }
    }

    private void handleSsl(ChannelHandlerContext context) {
        SslHandler sslHandler = this.sslHandlerFactory.createNettySSLHandler(context.alloc());
        try {
            context.pipeline().replace((ChannelHandler)this, SSL_HANDLER_NAME, (ChannelHandler)sslHandler);
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            throw t;
        }
    }

    private class NonSslHandler
    extends ChannelInboundHandlerAdapter {
        private NonSslHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            HttpRequest request = msg instanceof HttpRequest ? (HttpRequest)msg : null;
            String path = request == null ? "" : request.uri();
            String redirectAddress = this.getRedirectAddress(ctx);
            log.trace("Received non-SSL request, redirecting to {}{}", (Object)redirectAddress, (Object)path);
            HttpResponse response = HandlerRedirectUtils.getRedirectResponse(redirectAddress, path, HttpResponseStatus.MOVED_PERMANENTLY);
            if (request != null) {
                KeepAliveWrite.flush(ctx, request, response);
            } else {
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        private String getRedirectAddress(ChannelHandlerContext ctx) throws Exception {
            return RedirectingSslHandler.this.redirectBaseUrl.isDone() ? RedirectingSslHandler.this.redirectBaseUrl.get() : RedirectingSslHandler.this.confRedirectBaseUrl + ((InetSocketAddress)ctx.channel().localAddress()).getPort();
        }
    }
}

