/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.filter;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.EventOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.TraceOptions;
import org.apache.flink.events.EventBuilder;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricType;
import org.apache.flink.runtime.metrics.filter.ReporterFilter;
import org.apache.flink.traces.SpanBuilder;

public class DefaultReporterFilters {
    private static final EnumSet<MetricType> ALL_METRIC_TYPES = EnumSet.allOf(MetricType.class);
    @VisibleForTesting
    static final String LIST_DELIMITER = ",";

    public static ReporterFilter<Metric> metricsFromConfiguration(Configuration configuration) {
        return DefaultReporterFilters.fromConfiguration(configuration, (ConfigOption<List<String>>)MetricOptions.REPORTER_INCLUDES, (ConfigOption<List<String>>)MetricOptions.REPORTER_EXCLUDES, MetricReporterFilter::new);
    }

    public static ReporterFilter<SpanBuilder> tracesFromConfiguration(Configuration configuration) {
        return DefaultReporterFilters.fromConfiguration(configuration, (ConfigOption<List<String>>)TraceOptions.REPORTER_INCLUDES, (ConfigOption<List<String>>)TraceOptions.REPORTER_EXCLUDES, TraceReporterFilter::new);
    }

    public static ReporterFilter<EventBuilder> eventsFromConfiguration(Configuration configuration) {
        return DefaultReporterFilters.fromConfiguration(configuration, (ConfigOption<List<String>>)EventOptions.REPORTER_INCLUDES, (ConfigOption<List<String>>)EventOptions.REPORTER_EXCLUDES, EventReporterFilter::new);
    }

    private static <REPORTED> ReporterFilter<REPORTED> fromConfiguration(Configuration configuration, ConfigOption<List<String>> optionIncludes, ConfigOption<List<String>> optionExcludes, BiFunction<List<FilterSpec>, List<FilterSpec>, ReporterFilter<REPORTED>> factory) {
        List includes = (List)configuration.get(optionIncludes);
        List excludes = (List)configuration.get(optionExcludes);
        List includeFilters = includes.stream().map(DefaultReporterFilters::parse).collect(Collectors.toList());
        List excludeFilters = excludes.stream().map(DefaultReporterFilters::parse).collect(Collectors.toList());
        return factory.apply(includeFilters, excludeFilters);
    }

    private static FilterSpec parse(String filter) {
        String[] split = filter.split(":");
        Pattern scope = DefaultReporterFilters.convertToPattern(split[0]);
        Pattern name = split.length > 1 ? DefaultReporterFilters.convertToPattern(split[1]) : DefaultReporterFilters.convertToPattern("*");
        EnumSet<MetricType> type = split.length > 2 ? DefaultReporterFilters.parseMetricTypes(split[2]) : ALL_METRIC_TYPES;
        return new FilterSpec(scope, name, type);
    }

    @VisibleForTesting
    static Pattern convertToPattern(String scopeOrNameComponent) {
        String[] split = scopeOrNameComponent.split(LIST_DELIMITER);
        String rawPattern = Arrays.stream(split).map(s -> s.replaceAll("\\.", "\\.")).map(s -> s.replaceAll("\\*", ".*")).collect(Collectors.joining("|", "(", ")"));
        return Pattern.compile(rawPattern);
    }

    @VisibleForTesting
    static EnumSet<MetricType> parseMetricTypes(String typeComponent) {
        String[] split = typeComponent.split(LIST_DELIMITER);
        if (split.length == 1 && split[0].equals("*")) {
            return ALL_METRIC_TYPES;
        }
        return EnumSet.copyOf(Arrays.stream(split).map(s -> (MetricType)ConfigurationUtils.convertToEnum((Object)s, MetricType.class)).collect(Collectors.toSet()));
    }

    private static class FilterSpec {
        private final Pattern scopePattern;
        private final Pattern namePattern;
        private final EnumSet<MetricType> types;

        private FilterSpec(Pattern scopePattern, Pattern namePattern, EnumSet<MetricType> types) {
            this.scopePattern = scopePattern;
            this.namePattern = namePattern;
            this.types = types;
        }
    }

    static class EventReporterFilter
    extends AbstractReporterFilter<EventBuilder> {
        EventReporterFilter(List<FilterSpec> includes, List<FilterSpec> excludes) {
            super(includes, excludes);
        }

        @Override
        public boolean filter(EventBuilder reported, String name, String logicalScope) {
            for (FilterSpec exclude : this.excludes) {
                if (!exclude.namePattern.matcher(name).matches() || !exclude.scopePattern.matcher(logicalScope).matches()) continue;
                return false;
            }
            for (FilterSpec include : this.includes) {
                if (!include.namePattern.matcher(name).matches() || !include.scopePattern.matcher(logicalScope).matches()) continue;
                return true;
            }
            return false;
        }
    }

    static class TraceReporterFilter
    extends AbstractReporterFilter<SpanBuilder> {
        TraceReporterFilter(List<FilterSpec> includes, List<FilterSpec> excludes) {
            super(includes, excludes);
        }

        @Override
        public boolean filter(SpanBuilder reported, String name, String logicalScope) {
            for (FilterSpec exclude : this.excludes) {
                if (!exclude.namePattern.matcher(name).matches() || !exclude.scopePattern.matcher(logicalScope).matches()) continue;
                return false;
            }
            for (FilterSpec include : this.includes) {
                if (!include.namePattern.matcher(name).matches() || !include.scopePattern.matcher(logicalScope).matches()) continue;
                return true;
            }
            return false;
        }
    }

    static class MetricReporterFilter
    extends AbstractReporterFilter<Metric> {
        MetricReporterFilter(List<FilterSpec> includes, List<FilterSpec> excludes) {
            super(includes, excludes);
        }

        @Override
        public boolean filter(Metric reported, String name, String logicalScope) {
            for (FilterSpec exclude : this.excludes) {
                if (!exclude.namePattern.matcher(name).matches() || !exclude.scopePattern.matcher(logicalScope).matches() || !exclude.types.contains(reported.getMetricType())) continue;
                return false;
            }
            for (FilterSpec include : this.includes) {
                if (!include.namePattern.matcher(name).matches() || !include.scopePattern.matcher(logicalScope).matches() || !include.types.contains(reported.getMetricType())) continue;
                return true;
            }
            return false;
        }
    }

    static abstract class AbstractReporterFilter<T>
    implements ReporterFilter<T> {
        protected final List<FilterSpec> includes;
        protected final List<FilterSpec> excludes;

        AbstractReporterFilter(List<FilterSpec> includes, List<FilterSpec> excludes) {
            this.includes = includes;
            this.excludes = excludes;
        }
    }
}

