/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.functions;

import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalProcessWindowContext;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.Collector;

public final class InternalIterableProcessWindowFunction<IN, OUT, KEY, W extends Window>
extends WrappingFunction<ProcessWindowFunction<IN, OUT, KEY, W>>
implements InternalWindowFunction<Iterable<IN>, OUT, KEY, W> {
    private static final long serialVersionUID = 1L;
    private final InternalProcessWindowContext<IN, OUT, KEY, W> ctx;

    public InternalIterableProcessWindowFunction(ProcessWindowFunction<IN, OUT, KEY, W> wrappedFunction) {
        super(wrappedFunction);
        this.ctx = new InternalProcessWindowContext<IN, OUT, KEY, W>(wrappedFunction);
    }

    @Override
    public void process(KEY key, W window, InternalWindowFunction.InternalWindowContext context, Iterable<IN> input, Collector<OUT> out) throws Exception {
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessWindowFunction wrappedFunction = (ProcessWindowFunction)this.wrappedFunction;
        wrappedFunction.process(key, this.ctx, input, out);
    }

    @Override
    public void clear(W window, InternalWindowFunction.InternalWindowContext context) throws Exception {
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessWindowFunction wrappedFunction = (ProcessWindowFunction)this.wrappedFunction;
        wrappedFunction.clear(this.ctx);
    }

    public RuntimeContext getRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }

    public IterationRuntimeContext getIterationRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }
}

