/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Preconditions;

@Internal
public class TimestampsAndWatermarksTransformation<IN>
extends PhysicalTransformation<IN> {
    private final Transformation<IN> input;
    private final WatermarkStrategy<IN> watermarkStrategy;
    private ChainingStrategy chainingStrategy = ChainingStrategy.DEFAULT_CHAINING_STRATEGY;

    public TimestampsAndWatermarksTransformation(String name, int parallelism, Transformation<IN> input, WatermarkStrategy<IN> watermarkStrategy, boolean parallelismConfigured) {
        super(name, input.getOutputType(), parallelism, parallelismConfigured);
        this.input = input;
        this.watermarkStrategy = watermarkStrategy;
    }

    public TypeInformation<IN> getInputType() {
        return this.input.getOutputType();
    }

    public WatermarkStrategy<IN> getWatermarkStrategy() {
        return this.watermarkStrategy;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList transformations = Lists.newArrayList();
        transformations.add(this);
        transformations.addAll(this.input.getTransitivePredecessors());
        return transformations;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    @Override
    public void setChainingStrategy(ChainingStrategy chainingStrategy) {
        this.chainingStrategy = (ChainingStrategy)((Object)Preconditions.checkNotNull((Object)((Object)chainingStrategy)));
    }
}

