/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationConnectionListener;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.registration.RetryingRegistrationConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.TaskExecutorRegistration;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationRejection;
import org.apache.flink.runtime.taskexecutor.TaskExecutorRegistrationSuccess;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class TaskExecutorToResourceManagerConnection
extends RegisteredRpcConnection<ResourceManagerId, ResourceManagerGateway, TaskExecutorRegistrationSuccess, TaskExecutorRegistrationRejection> {
    private final RpcService rpcService;
    private final RetryingRegistrationConfiguration retryingRegistrationConfiguration;
    private final RegistrationConnectionListener<TaskExecutorToResourceManagerConnection, TaskExecutorRegistrationSuccess, TaskExecutorRegistrationRejection> registrationListener;
    private final TaskExecutorRegistration taskExecutorRegistration;

    public TaskExecutorToResourceManagerConnection(Logger log, RpcService rpcService, RetryingRegistrationConfiguration retryingRegistrationConfiguration, String resourceManagerAddress, ResourceManagerId resourceManagerId, Executor executor, RegistrationConnectionListener<TaskExecutorToResourceManagerConnection, TaskExecutorRegistrationSuccess, TaskExecutorRegistrationRejection> registrationListener, TaskExecutorRegistration taskExecutorRegistration) {
        super(log, resourceManagerAddress, resourceManagerId, executor);
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.retryingRegistrationConfiguration = (RetryingRegistrationConfiguration)Preconditions.checkNotNull((Object)retryingRegistrationConfiguration);
        this.registrationListener = (RegistrationConnectionListener)Preconditions.checkNotNull(registrationListener);
        this.taskExecutorRegistration = (TaskExecutorRegistration)Preconditions.checkNotNull((Object)taskExecutorRegistration);
    }

    @Override
    protected RetryingRegistration<ResourceManagerId, ResourceManagerGateway, TaskExecutorRegistrationSuccess, TaskExecutorRegistrationRejection> generateRegistration() {
        return new ResourceManagerRegistration(this.log, this.rpcService, this.getTargetAddress(), (ResourceManagerId)((Object)this.getTargetLeaderId()), this.retryingRegistrationConfiguration, this.taskExecutorRegistration);
    }

    @Override
    protected void onRegistrationSuccess(TaskExecutorRegistrationSuccess success) {
        this.log.info("Successful registration at resource manager {} under registration id {}.", (Object)this.getTargetAddress(), (Object)success.getRegistrationId());
        this.registrationListener.onRegistrationSuccess(this, success);
    }

    @Override
    protected void onRegistrationRejection(TaskExecutorRegistrationRejection rejection) {
        this.registrationListener.onRegistrationRejection(this.getTargetAddress(), rejection);
    }

    @Override
    protected void onRegistrationFailure(Throwable failure) {
        this.log.info("Failed to register at resource manager {}.", (Object)this.getTargetAddress(), (Object)failure);
        this.registrationListener.onRegistrationFailure(failure);
    }

    private static class ResourceManagerRegistration
    extends RetryingRegistration<ResourceManagerId, ResourceManagerGateway, TaskExecutorRegistrationSuccess, TaskExecutorRegistrationRejection> {
        private final TaskExecutorRegistration taskExecutorRegistration;

        ResourceManagerRegistration(Logger log, RpcService rpcService, String targetAddress, ResourceManagerId resourceManagerId, RetryingRegistrationConfiguration retryingRegistrationConfiguration, TaskExecutorRegistration taskExecutorRegistration) {
            super(log, rpcService, "ResourceManager", ResourceManagerGateway.class, targetAddress, resourceManagerId, retryingRegistrationConfiguration);
            this.taskExecutorRegistration = taskExecutorRegistration;
        }

        @Override
        protected CompletableFuture<RegistrationResponse> invokeRegistration(ResourceManagerGateway resourceManager, ResourceManagerId fencingToken, long timeoutMillis) throws Exception {
            Duration timeout = Duration.ofMillis(timeoutMillis);
            return resourceManager.registerTaskExecutor(this.taskExecutorRegistration, timeout);
        }
    }
}

