/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.AbstractKeyedState;
import org.apache.flink.runtime.state.v2.SyncIteratorWrapper;
import org.apache.flink.runtime.state.v2.internal.InternalMapState;

public class AbstractMapState<K, N, UK, V>
extends AbstractKeyedState<K, N, V>
implements InternalMapState<K, N, UK, V> {
    public AbstractMapState(StateRequestHandler stateRequestHandler, TypeSerializer<V> serializer) {
        super(stateRequestHandler, serializer);
    }

    public StateFuture<V> asyncGet(UK key) {
        return this.handleRequest(StateRequestType.MAP_GET, key);
    }

    public StateFuture<Void> asyncPut(UK key, V value) {
        return this.handleRequest(StateRequestType.MAP_PUT, Tuple2.of(key, value));
    }

    public StateFuture<Void> asyncPutAll(Map<UK, V> map) {
        return this.handleRequest(StateRequestType.MAP_PUT_ALL, map);
    }

    public StateFuture<Void> asyncRemove(UK key) {
        return this.handleRequest(StateRequestType.MAP_REMOVE, key);
    }

    public StateFuture<Boolean> asyncContains(UK key) {
        return this.handleRequest(StateRequestType.MAP_CONTAINS, key);
    }

    public StateFuture<StateIterator<Map.Entry<UK, V>>> asyncEntries() {
        return this.handleRequest(StateRequestType.MAP_ITER, null);
    }

    public StateFuture<StateIterator<UK>> asyncKeys() {
        return this.handleRequest(StateRequestType.MAP_ITER_KEY, null);
    }

    public StateFuture<StateIterator<V>> asyncValues() {
        return this.handleRequest(StateRequestType.MAP_ITER_VALUE, null);
    }

    public StateFuture<Boolean> asyncIsEmpty() {
        return this.handleRequest(StateRequestType.MAP_IS_EMPTY, null);
    }

    public V get(UK key) {
        return (V)this.handleRequestSync(StateRequestType.MAP_GET, key);
    }

    public void put(UK key, V value) {
        this.handleRequestSync(StateRequestType.MAP_PUT, Tuple2.of(key, value));
    }

    public void putAll(Map<UK, V> map) {
        this.handleRequestSync(StateRequestType.MAP_PUT_ALL, map);
    }

    public void remove(UK key) {
        this.handleRequestSync(StateRequestType.MAP_REMOVE, key);
    }

    public boolean contains(UK key) {
        return (Boolean)this.handleRequestSync(StateRequestType.MAP_CONTAINS, key);
    }

    public Iterable<Map.Entry<UK, V>> entries() {
        return this::iterator;
    }

    public Iterable<UK> keys() {
        return () -> {
            StateIterator stateIterator = (StateIterator)this.handleRequestSync(StateRequestType.MAP_ITER_KEY, null);
            return new SyncIteratorWrapper(stateIterator);
        };
    }

    public Iterable<V> values() {
        return () -> {
            StateIterator stateIterator = (StateIterator)this.handleRequestSync(StateRequestType.MAP_ITER_VALUE, null);
            return new SyncIteratorWrapper(stateIterator);
        };
    }

    public Iterator<Map.Entry<UK, V>> iterator() {
        StateIterator stateIterator = (StateIterator)this.handleRequestSync(StateRequestType.MAP_ITER, null);
        return new SyncIteratorWrapper<Map.Entry<UK, V>>(stateIterator);
    }

    public boolean isEmpty() {
        return (Boolean)this.handleRequestSync(StateRequestType.MAP_IS_EMPTY, null);
    }
}

