/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.AbstractBlockingResultInfo;
import org.apache.flink.util.Preconditions;

public class PointwiseBlockingResultInfo
extends AbstractBlockingResultInfo {
    @VisibleForTesting
    PointwiseBlockingResultInfo(IntermediateDataSetID resultId, int numOfPartitions, int numOfSubpartitions) {
        this(resultId, numOfPartitions, numOfSubpartitions, new HashMap<Integer, long[]>());
    }

    PointwiseBlockingResultInfo(IntermediateDataSetID resultId, int numOfPartitions, int numOfSubpartitions, Map<Integer, long[]> subpartitionBytesByPartitionIndex) {
        super(resultId, numOfPartitions, numOfSubpartitions, subpartitionBytesByPartitionIndex);
    }

    @Override
    public boolean isBroadcast() {
        return false;
    }

    @Override
    public boolean isSingleSubpartitionContainsAllData() {
        return false;
    }

    @Override
    public boolean isPointwise() {
        return true;
    }

    @Override
    public int getNumPartitions() {
        return this.numOfPartitions;
    }

    @Override
    public int getNumSubpartitions(int partitionIndex) {
        return this.numOfSubpartitions;
    }

    @Override
    public long getNumBytesProduced() {
        Preconditions.checkState((this.subpartitionBytesByPartitionIndex.size() == this.numOfPartitions ? 1 : 0) != 0, (Object)"Not all partition infos are ready");
        return this.subpartitionBytesByPartitionIndex.values().stream().flatMapToLong(Arrays::stream).reduce(0L, Long::sum);
    }
}

