/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.Preconditions;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class JobConfigInfo
implements ResponseBody {
    public static final String FIELD_NAME_JOB_ID = "jid";
    public static final String FIELD_NAME_JOB_NAME = "name";
    public static final String FIELD_NAME_EXECUTION_CONFIG = "execution-config";
    private final JobID jobId;
    private final String jobName;
    @Nullable
    private final ExecutionConfigInfo executionConfigInfo;

    public JobConfigInfo(JobID jobId, String jobName, @Nullable ExecutionConfigInfo executionConfigInfo) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.executionConfigInfo = executionConfigInfo;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    @Nullable
    public ExecutionConfigInfo getExecutionConfigInfo() {
        return this.executionConfigInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobConfigInfo that = (JobConfigInfo)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobName, that.jobName) && Objects.equals(this.executionConfigInfo, that.executionConfigInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.jobName, this.executionConfigInfo);
    }

    public static final class ExecutionConfigInfo {
        public static final String FIELD_NAME_RESTART_STRATEGY = "restart-strategy";
        public static final String FIELD_NAME_PARALLELISM = "job-parallelism";
        public static final String FIELD_NAME_OBJECT_REUSE_MODE = "object-reuse-mode";
        public static final String FIELD_NAME_GLOBAL_JOB_PARAMETERS = "user-config";
        @JsonProperty(value="restart-strategy")
        private final String restartStrategy;
        @JsonProperty(value="job-parallelism")
        private final int parallelism;
        @JsonProperty(value="object-reuse-mode")
        private final boolean isObjectReuse;
        @JsonProperty(value="user-config")
        private final Map<String, String> globalJobParameters;

        @JsonCreator
        public ExecutionConfigInfo(@JsonProperty(value="restart-strategy") String restartStrategy, @JsonProperty(value="job-parallelism") int parallelism, @JsonProperty(value="object-reuse-mode") boolean isObjectReuse, @JsonProperty(value="user-config") Map<String, String> globalJobParameters) {
            this.restartStrategy = (String)Preconditions.checkNotNull((Object)restartStrategy);
            this.parallelism = parallelism;
            this.isObjectReuse = isObjectReuse;
            this.globalJobParameters = (Map)Preconditions.checkNotNull(globalJobParameters);
        }

        public String getRestartStrategy() {
            return this.restartStrategy;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        @JsonIgnore
        public boolean isObjectReuse() {
            return this.isObjectReuse;
        }

        public Map<String, String> getGlobalJobParameters() {
            return this.globalJobParameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutionConfigInfo that = (ExecutionConfigInfo)o;
            return this.parallelism == that.parallelism && this.isObjectReuse == that.isObjectReuse && Objects.equals(this.restartStrategy, that.restartStrategy) && Objects.equals(this.globalJobParameters, that.globalJobParameters);
        }

        public int hashCode() {
            return Objects.hash(this.restartStrategy, this.parallelism, this.isObjectReuse, this.globalJobParameters);
        }

        public static ExecutionConfigInfo from(ArchivedExecutionConfig archivedExecutionConfig) {
            return new ExecutionConfigInfo(archivedExecutionConfig.getRestartStrategyDescription(), archivedExecutionConfig.getParallelism(), archivedExecutionConfig.getObjectReuseEnabled(), ConfigurationUtils.hideSensitiveValues((Map)archivedExecutionConfig.getGlobalJobParameters()));
        }
    }

    public static final class Deserializer
    extends StdDeserializer<JobConfigInfo> {
        private static final long serialVersionUID = -3580088509877177213L;

        public Deserializer() {
            super(JobConfigInfo.class);
        }

        public JobConfigInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
            JobID jobId = JobID.fromHexString((String)rootNode.get(JobConfigInfo.FIELD_NAME_JOB_ID).asText());
            String jobName = rootNode.get(JobConfigInfo.FIELD_NAME_JOB_NAME).asText();
            ExecutionConfigInfo executionConfigInfo = rootNode.has(JobConfigInfo.FIELD_NAME_EXECUTION_CONFIG) ? (ExecutionConfigInfo)RestMapperUtils.getStrictObjectMapper().treeToValue((TreeNode)rootNode.get(JobConfigInfo.FIELD_NAME_EXECUTION_CONFIG), ExecutionConfigInfo.class) : null;
            return new JobConfigInfo(jobId, jobName, executionConfigInfo);
        }
    }

    public static final class Serializer
    extends StdSerializer<JobConfigInfo> {
        private static final long serialVersionUID = -1551666039618928811L;

        public Serializer() {
            super(JobConfigInfo.class);
        }

        public void serialize(JobConfigInfo jobConfigInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(JobConfigInfo.FIELD_NAME_JOB_ID, jobConfigInfo.getJobId().toString());
            jsonGenerator.writeStringField(JobConfigInfo.FIELD_NAME_JOB_NAME, jobConfigInfo.getJobName());
            if (jobConfigInfo.getExecutionConfigInfo() != null) {
                jsonGenerator.writeObjectField(JobConfigInfo.FIELD_NAME_EXECUTION_CONFIG, (Object)jobConfigInfo.getExecutionConfigInfo());
            }
            jsonGenerator.writeEndObject();
        }
    }
}

