/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateEntry;
import org.apache.flink.runtime.query.KvStateRegistryListener;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.internal.InternalKvState;

public class KvStateRegistry {
    private final ConcurrentHashMap<KvStateID, KvStateEntry<?, ?, ?>> registeredKvStates = new ConcurrentHashMap(4);
    private final ConcurrentHashMap<JobID, KvStateRegistryListener> listeners = new ConcurrentHashMap(4);

    public void registerListener(JobID jobId, KvStateRegistryListener listener) {
        KvStateRegistryListener previousValue = this.listeners.putIfAbsent(jobId, listener);
        if (previousValue != null) {
            throw new IllegalStateException("Listener already registered under " + jobId + ".");
        }
    }

    public void unregisterListener(JobID jobId) {
        this.listeners.remove(jobId);
    }

    public KvStateID registerKvState(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, InternalKvState<?, ?, ?> kvState, ClassLoader userClassLoader) {
        KvStateID kvStateId = new KvStateID();
        if (this.registeredKvStates.putIfAbsent(kvStateId, new KvStateEntry(kvState, userClassLoader)) == null) {
            KvStateRegistryListener listener = this.getKvStateRegistryListener(jobId);
            if (listener != null) {
                listener.notifyKvStateRegistered(jobId, jobVertexId, keyGroupRange, registrationName, kvStateId);
            }
            return kvStateId;
        }
        throw new IllegalStateException("State \"" + registrationName + " \"(id=" + kvStateId + ") appears registered although it should not.");
    }

    public void unregisterKvState(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId) {
        KvStateEntry<?, ?, ?> entry = this.registeredKvStates.remove(kvStateId);
        if (entry != null) {
            entry.clear();
            KvStateRegistryListener listener = this.getKvStateRegistryListener(jobId);
            if (listener != null) {
                listener.notifyKvStateUnregistered(jobId, jobVertexId, keyGroupRange, registrationName);
            }
        }
    }

    public KvStateEntry<?, ?, ?> getKvState(KvStateID kvStateId) {
        return this.registeredKvStates.get(kvStateId);
    }

    public TaskKvStateRegistry createTaskRegistry(JobID jobId, JobVertexID jobVertexId) {
        return new TaskKvStateRegistry(this, jobId, jobVertexId);
    }

    private KvStateRegistryListener getKvStateRegistryListener(JobID jobId) {
        KvStateRegistryListener listener = this.listeners.get(HighAvailabilityServices.DEFAULT_JOB_ID);
        if (listener == null) {
            listener = this.listeners.get(jobId);
        }
        return listener;
    }
}

