/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.util.Preconditions;

public class MiniClusterConfiguration {
    static final int DEFAULT_IO_POOL_SIZE = 4;
    private final UnmodifiableConfiguration configuration;
    private final int numTaskManagers;
    private final RpcServiceSharing rpcServiceSharing;
    @Nullable
    private final String commonBindAddress;
    private final MiniCluster.HaServices haServices;
    @Nullable
    private final PluginManager pluginManager;

    public MiniClusterConfiguration(Configuration configuration, int numTaskManagers, RpcServiceSharing rpcServiceSharing, @Nullable String commonBindAddress, MiniCluster.HaServices haServices, @Nullable PluginManager pluginManager) {
        this.numTaskManagers = numTaskManagers;
        this.configuration = this.generateConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.rpcServiceSharing = (RpcServiceSharing)((Object)Preconditions.checkNotNull((Object)((Object)rpcServiceSharing)));
        this.commonBindAddress = commonBindAddress;
        this.haServices = haServices;
        this.pluginManager = pluginManager;
    }

    private UnmodifiableConfiguration generateConfiguration(Configuration configuration) {
        Configuration modifiedConfig = new Configuration(configuration);
        TaskExecutorResourceUtils.adjustForLocalExecution(modifiedConfig);
        if (!modifiedConfig.contains(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS)) {
            modifiedConfig.set(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS, (Object)16);
        }
        if (!modifiedConfig.contains(ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE)) {
            modifiedConfig.set(ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE, (Object)4);
        }
        if (!modifiedConfig.contains(RpcOptions.ASK_TIMEOUT_DURATION)) {
            modifiedConfig.set(RpcOptions.ASK_TIMEOUT_DURATION, (Object)Duration.ofMinutes(5L));
        }
        return new UnmodifiableConfiguration(modifiedConfig);
    }

    public RpcServiceSharing getRpcServiceSharing() {
        return this.rpcServiceSharing;
    }

    @Nullable
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public int getNumTaskManagers() {
        return this.numTaskManagers;
    }

    public String getJobManagerExternalAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : (String)this.configuration.get(JobManagerOptions.ADDRESS, (Object)"localhost");
    }

    public String getTaskManagerExternalAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : (String)this.configuration.get(TaskManagerOptions.HOST, (Object)"localhost");
    }

    public String getJobManagerExternalPortRange() {
        return String.valueOf(this.configuration.get(JobManagerOptions.PORT, (Object)0));
    }

    public String getTaskManagerExternalPortRange() {
        return (String)this.configuration.get(TaskManagerOptions.RPC_PORT);
    }

    public String getJobManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : (String)this.configuration.get(JobManagerOptions.BIND_HOST, (Object)"localhost");
    }

    public String getTaskManagerBindAddress() {
        return this.commonBindAddress != null ? this.commonBindAddress : (String)this.configuration.get(TaskManagerOptions.BIND_HOST, (Object)"localhost");
    }

    public UnmodifiableConfiguration getConfiguration() {
        return this.configuration;
    }

    public MiniCluster.HaServices getHaServices() {
        return this.haServices;
    }

    public String toString() {
        return "MiniClusterConfiguration {singleRpcService=" + this.rpcServiceSharing + ", numTaskManagers=" + this.numTaskManagers + ", commonBindAddress='" + this.commonBindAddress + "', config=" + this.configuration + "}";
    }

    public static class Builder {
        private Configuration configuration = new Configuration();
        private int numTaskManagers = 1;
        private int numSlotsPerTaskManager = 1;
        private RpcServiceSharing rpcServiceSharing = RpcServiceSharing.SHARED;
        @Nullable
        private String commonBindAddress = null;
        private MiniCluster.HaServices haServices = MiniCluster.HaServices.CONFIGURED;
        private boolean useRandomPorts = false;
        @Nullable
        private PluginManager pluginManager;

        public Builder setConfiguration(Configuration configuration1) {
            this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration1);
            return this;
        }

        public Builder setNumTaskManagers(int numTaskManagers) {
            this.numTaskManagers = numTaskManagers;
            return this;
        }

        public Builder setNumSlotsPerTaskManager(int numSlotsPerTaskManager) {
            this.numSlotsPerTaskManager = numSlotsPerTaskManager;
            return this;
        }

        public Builder setRpcServiceSharing(RpcServiceSharing rpcServiceSharing) {
            this.rpcServiceSharing = (RpcServiceSharing)((Object)Preconditions.checkNotNull((Object)((Object)rpcServiceSharing)));
            return this;
        }

        public Builder setCommonBindAddress(String commonBindAddress) {
            this.commonBindAddress = commonBindAddress;
            return this;
        }

        public Builder setHaServices(MiniCluster.HaServices haServices) {
            this.haServices = haServices;
            return this;
        }

        public Builder withRandomPorts() {
            this.useRandomPorts = true;
            return this;
        }

        public Builder setPluginManager(PluginManager pluginManager) {
            this.pluginManager = (PluginManager)Preconditions.checkNotNull((Object)pluginManager);
            return this;
        }

        public MiniClusterConfiguration build() {
            Configuration modifiedConfiguration = new Configuration(this.configuration);
            modifiedConfiguration.set(TaskManagerOptions.NUM_TASK_SLOTS, (Object)this.numSlotsPerTaskManager);
            modifiedConfiguration.set(RestOptions.ADDRESS, (Object)((String)modifiedConfiguration.get(RestOptions.ADDRESS, (Object)"localhost")));
            if (this.useRandomPorts) {
                if (!this.configuration.contains(JobManagerOptions.PORT)) {
                    modifiedConfiguration.set(JobManagerOptions.PORT, (Object)0);
                }
                if (!this.configuration.contains(RestOptions.BIND_PORT)) {
                    modifiedConfiguration.set(RestOptions.BIND_PORT, (Object)"0");
                }
            }
            return new MiniClusterConfiguration(modifiedConfiguration, this.numTaskManagers, this.rpcServiceSharing, this.commonBindAddress, this.haServices, this.pluginManager);
        }
    }
}

