/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.jsonplan;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamNode;

@Internal
public class JsonPlanGenerator {
    private static final String NOT_SET = "";
    private static final String EMPTY = "{}";

    public static JobPlanInfo.Plan generatePlan(JobGraph jg) {
        return JsonPlanGenerator.generatePlan(jg.getJobID(), jg.getName(), jg.getJobType(), jg.getVertices(), VertexParallelism.empty());
    }

    public static JobPlanInfo.Plan generatePlan(JobID jobID, String jobName, JobType jobType, Iterable<JobVertex> vertices, VertexParallelism vertexParallelism) {
        try {
            ArrayList<JobPlanInfo.Plan.Node> nodes = new ArrayList<JobPlanInfo.Plan.Node>();
            for (JobVertex vertex : vertices) {
                String operator = vertex.getOperatorName() != null ? vertex.getOperatorName() : NOT_SET;
                String operatorDescr = vertex.getOperatorDescription() != null ? vertex.getOperatorDescription() : NOT_SET;
                String optimizerProps = vertex.getResultOptimizerProperties() != null ? vertex.getResultOptimizerProperties() : EMPTY;
                String description = vertex.getOperatorPrettyName() != null ? vertex.getOperatorPrettyName() : vertex.getName();
                description = StringEscapeUtils.escapeHtml4((String)description);
                description = description.replace("\n", "<br/>");
                description = description.replace("\\", "&#92;");
                operatorDescr = StringEscapeUtils.escapeHtml4((String)operatorDescr);
                operatorDescr = operatorDescr.replace("\n", "<br/>");
                JobVertexID vertexID = vertex.getID();
                long parallelism = vertexParallelism.getParallelismOptional(vertexID).orElse(vertex.getParallelism()).intValue();
                ArrayList<JobPlanInfo.Plan.Node.Input> inputs = new ArrayList<JobPlanInfo.Plan.Node.Input>();
                if (!vertex.isInputVertex()) {
                    for (int inputNum = 0; inputNum < vertex.getInputs().size(); ++inputNum) {
                        JobVertex predecessor;
                        JobEdge edge = vertex.getInputs().get(inputNum);
                        if (edge.getSource() == null || (predecessor = edge.getSource().getProducer()) == null || predecessor.getID() == null) continue;
                        String inputId = predecessor.getID().toString();
                        if (edge.getSource().getResultType() == null || edge.getSource().getResultType().name() == null) continue;
                        String exchange = edge.getSource().getResultType().name().toLowerCase();
                        String shipStrategy = edge.getShipStrategyName();
                        String preProcessingOperation = edge.getPreProcessingOperationName();
                        String operatorLevelCaching = edge.getOperatorLevelCachingDescription();
                        inputs.add(new JobPlanInfo.Plan.Node.Input(inputId, inputNum, exchange, shipStrategy, preProcessingOperation, operatorLevelCaching));
                    }
                }
                nodes.add(new JobPlanInfo.Plan.Node(vertexID.toString(), operator, parallelism, operatorDescr, description, optimizerProps, inputs));
            }
            return new JobPlanInfo.Plan(jobID.toString(), jobName, jobType.name(), nodes);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate plan", e);
        }
    }

    public static String generateStreamGraphJson(StreamGraph sg, Map<Integer, JobVertexID> jobVertexIdMap) {
        String string;
        StringWriter writer = new StringWriter(1024);
        try {
            try (JsonGenerator gen = new JsonFactory().createGenerator((Writer)writer);){
                gen.writeStartObject();
                gen.writeArrayFieldStart("nodes");
                for (StreamNode node : sg.getStreamNodes()) {
                    gen.writeStartObject();
                    gen.writeStringField("id", String.valueOf(node.getId()));
                    gen.writeNumberField("parallelism", node.getParallelism());
                    gen.writeStringField("operator", node.getOperatorName());
                    gen.writeStringField("description", node.getOperatorDescription());
                    if (jobVertexIdMap.containsKey(node.getId())) {
                        gen.writeStringField("job_vertex_id", jobVertexIdMap.get(node.getId()).toString());
                    }
                    gen.writeArrayFieldStart("inputs");
                    List<StreamEdge> inEdges = node.getInEdges();
                    for (int inputNum = 0; inputNum < inEdges.size(); ++inputNum) {
                        StreamEdge edge = inEdges.get(inputNum);
                        gen.writeStartObject();
                        gen.writeNumberField("num", inputNum);
                        gen.writeStringField("id", String.valueOf(edge.getSourceId()));
                        gen.writeStringField("ship_strategy", edge.getPartitioner().toString());
                        gen.writeStringField("exchange", edge.getExchangeMode().name());
                        gen.writeEndObject();
                    }
                    gen.writeEndArray();
                    gen.writeEndObject();
                }
                gen.writeEndArray();
                gen.writeEndObject();
            }
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to generate json stream plan", e);
            }
        }
        writer.close();
        return string;
    }
}

