/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import org.apache.flink.runtime.io.network.buffer.AbstractCompositeBuffer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.CompositeBuffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.util.Preconditions;

public class FullyFilledBuffer
extends AbstractCompositeBuffer {
    public FullyFilledBuffer(Buffer.DataType dataType, int length, boolean isCompressed) {
        super(dataType, length, isCompressed);
    }

    @Override
    public ByteBuf asByteBuf() {
        CompositeByteBuf compositeByteBuf = ((ByteBufAllocator)Preconditions.checkNotNull((Object)this.allocator)).compositeDirectBuffer();
        for (Buffer buffer : this.partialBuffers) {
            if (buffer instanceof CompositeBuffer) {
                buffer.setAllocator(this.allocator);
            }
            compositeByteBuf.addComponent(buffer.asByteBuf());
        }
        compositeByteBuf.writerIndex(this.currentLength);
        return compositeByteBuf;
    }

    @Override
    public void addPartialBuffer(Buffer buffer) {
        Preconditions.checkState((buffer.getDataType() == this.dataType ? 1 : 0) != 0, (Object)"Partial buffer data type must be the same as the fully filled buffer.");
        Preconditions.checkState((buffer.isCompressed() == this.isCompressed ? 1 : 0) != 0, (Object)"Partial buffer compression status must be the same as the fully filled buffer.");
        this.partialBuffers.add(buffer);
        this.currentLength += buffer.readableBytes();
        Preconditions.checkState((this.currentLength <= this.length ? 1 : 0) != 0);
    }
}

