/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV3Serializer;

@Internal
public class MetadataV4Serializer
extends MetadataV3Serializer {
    public static final MetadataSerializer INSTANCE = new MetadataV4Serializer();
    public static final int VERSION = 4;

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public CheckpointMetadata deserialize(DataInputStream dis, ClassLoader userCodeClassLoader, String externalPointer) throws IOException {
        return super.deserialize(dis, userCodeClassLoader, externalPointer).withProperties(this.deserializeProperties(dis));
    }

    @Override
    public void serialize(CheckpointMetadata checkpointMetadata, DataOutputStream dos) throws IOException {
        super.serialize(checkpointMetadata, dos);
        this.serializeProperties(checkpointMetadata.getCheckpointProperties(), dos);
    }

    private CheckpointProperties deserializeProperties(DataInputStream dis) throws IOException {
        try {
            return (CheckpointProperties)new ObjectInputStream(dis).readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Couldn't deserialize checkpoint properties", e);
        }
    }

    private void serializeProperties(CheckpointProperties properties, DataOutputStream dos) throws IOException {
        new ObjectOutputStream(dos).writeObject(properties);
    }
}

