/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blocklist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.blocklist.BlockedNode;
import org.apache.flink.runtime.blocklist.BlockedNodeAdditionResult;
import org.apache.flink.runtime.blocklist.BlocklistTracker;
import org.apache.flink.util.Preconditions;

public class DefaultBlocklistTracker
implements BlocklistTracker {
    private final Map<String, BlockedNode> blockedNodes = new HashMap<String, BlockedNode>();

    private AddStatus tryAddOrMerge(BlockedNode newNode) {
        BlockedNode merged;
        Preconditions.checkNotNull((Object)newNode);
        String nodeId = newNode.getNodeId();
        BlockedNode existingNode = this.blockedNodes.get(nodeId);
        if (existingNode == null) {
            this.blockedNodes.put(nodeId, newNode);
            return AddStatus.ADDED;
        }
        BlockedNode blockedNode = merged = newNode.getEndTimestamp() >= existingNode.getEndTimestamp() ? newNode : existingNode;
        if (!merged.equals(existingNode)) {
            this.blockedNodes.put(nodeId, merged);
            return AddStatus.MERGED;
        }
        return AddStatus.NONE;
    }

    @Override
    public BlockedNodeAdditionResult addNewBlockedNodes(Collection<BlockedNode> newNodes) {
        Preconditions.checkNotNull(newNodes);
        HashMap<String, BlockedNode> newlyAddedNodes = new HashMap<String, BlockedNode>();
        HashMap<String, BlockedNode> mergedNodes = new HashMap<String, BlockedNode>();
        block5: for (BlockedNode node : newNodes) {
            String nodeId = node.getNodeId();
            AddStatus status = this.tryAddOrMerge(node);
            switch (status) {
                case ADDED: {
                    newlyAddedNodes.put(nodeId, this.blockedNodes.get(nodeId));
                    continue block5;
                }
                case MERGED: {
                    mergedNodes.put(nodeId, this.blockedNodes.get(nodeId));
                    continue block5;
                }
                case NONE: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Add or merge status " + status + " is not supported.");
        }
        return new BlockedNodeAdditionResult(newlyAddedNodes.values(), mergedNodes.values());
    }

    @Override
    public boolean isBlockedNode(String nodeId) {
        Preconditions.checkNotNull((Object)nodeId);
        return this.blockedNodes.containsKey(nodeId);
    }

    @Override
    public Set<String> getAllBlockedNodeIds() {
        return Collections.unmodifiableSet(this.blockedNodes.keySet());
    }

    @Override
    public Collection<BlockedNode> getAllBlockedNodes() {
        return Collections.unmodifiableCollection(this.blockedNodes.values());
    }

    @Override
    public Collection<BlockedNode> removeTimeoutNodes(long currentTimestamp) {
        ArrayList<BlockedNode> removedNodes = new ArrayList<BlockedNode>();
        Iterator<BlockedNode> blockedNodeIterator = this.blockedNodes.values().iterator();
        while (blockedNodeIterator.hasNext()) {
            BlockedNode blockedNode = blockedNodeIterator.next();
            if (currentTimestamp < blockedNode.getEndTimestamp()) continue;
            removedNodes.add(blockedNode);
            blockedNodeIterator.remove();
        }
        return removedNodes;
    }

    private static enum AddStatus {
        ADDED,
        MERGED,
        NONE;

    }
}

