/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermarkstatus;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HeapPriorityQueue<T extends HeapPriorityQueueElement> {
    private static final int QUEUE_HEAD_INDEX = 1;
    @Nonnull
    private final PriorityComparator<T> elementPriorityComparator;
    @Nonnull
    private T[] queue;
    @Nonnegative
    private int size;

    public HeapPriorityQueue(@Nonnull PriorityComparator<T> elementPriorityComparator, @Nonnegative int minimumCapacity) {
        this.queue = new HeapPriorityQueueElement[this.getHeadElementIndex() + minimumCapacity];
        this.size = 0;
        this.elementPriorityComparator = elementPriorityComparator;
    }

    public void adjustModifiedElement(@Nonnull T element) {
        int elementIndex = element.getInternalIndex();
        if (element == this.queue[elementIndex]) {
            this.adjustElementAtIndex(element, elementIndex);
        }
    }

    @Nullable
    public T poll() {
        return this.size() > 0 ? (T)this.removeInternal(this.getHeadElementIndex()) : null;
    }

    @Nullable
    public T peek() {
        return this.queue[this.getHeadElementIndex()];
    }

    public boolean add(@Nonnull T toAdd) {
        this.addInternal(toAdd);
        return toAdd.getInternalIndex() == this.getHeadElementIndex();
    }

    public boolean remove(@Nonnull T toRemove) {
        int elementIndex = toRemove.getInternalIndex();
        this.removeInternal(elementIndex);
        return elementIndex == this.getHeadElementIndex();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        int arrayOffset = this.getHeadElementIndex();
        Arrays.fill(this.queue, arrayOffset, arrayOffset + this.size, null);
        this.size = 0;
    }

    private void resizeQueueArray(int desiredSize, int minRequiredSize) {
        if (HeapPriorityQueue.isValidArraySize(desiredSize)) {
            this.queue = (HeapPriorityQueueElement[])Arrays.copyOf(this.queue, desiredSize);
        } else if (HeapPriorityQueue.isValidArraySize(minRequiredSize)) {
            this.queue = (HeapPriorityQueueElement[])Arrays.copyOf(this.queue, 0x7FFFFFF7);
        } else {
            throw new OutOfMemoryError("Required minimum heap size " + minRequiredSize + " exceeds maximum size of 2147483639.");
        }
    }

    private void moveElementToIdx(T element, int idx) {
        this.queue[idx] = element;
        element.setInternalIndex(idx);
    }

    private static boolean isValidArraySize(int size) {
        return size >= 0 && size <= 0x7FFFFFF7;
    }

    private int getHeadElementIndex() {
        return 1;
    }

    private void addInternal(@Nonnull T element) {
        int newSize = this.increaseSizeByOne();
        this.moveElementToIdx(element, newSize);
        this.siftUp(newSize);
    }

    private T removeInternal(int removeIdx) {
        T[] heap = this.queue;
        T removedValue = heap[removeIdx];
        assert (removedValue.getInternalIndex() == removeIdx);
        int oldSize = this.size;
        if (removeIdx != oldSize) {
            T element = heap[oldSize];
            this.moveElementToIdx(element, removeIdx);
            this.adjustElementAtIndex(element, removeIdx);
        }
        heap[oldSize] = null;
        --this.size;
        return removedValue;
    }

    private void adjustElementAtIndex(T element, int index) {
        this.siftDown(index);
        if (this.queue[index] == element) {
            this.siftUp(index);
        }
    }

    private void siftUp(int idx) {
        T[] heap = this.queue;
        T currentElement = heap[idx];
        for (int parentIdx = idx >>> 1; parentIdx > 0 && this.isElementPriorityLessThen(currentElement, heap[parentIdx]); parentIdx >>>= 1) {
            this.moveElementToIdx(heap[parentIdx], idx);
            idx = parentIdx;
        }
        this.moveElementToIdx(currentElement, idx);
    }

    private void siftDown(int idx) {
        T[] heap = this.queue;
        int heapSize = this.size;
        T currentElement = heap[idx];
        int firstChildIdx = idx << 1;
        int secondChildIdx = firstChildIdx + 1;
        if (this.isElementIndexValid(secondChildIdx, heapSize) && this.isElementPriorityLessThen(heap[secondChildIdx], heap[firstChildIdx])) {
            firstChildIdx = secondChildIdx;
        }
        while (this.isElementIndexValid(firstChildIdx, heapSize) && this.isElementPriorityLessThen(heap[firstChildIdx], currentElement)) {
            this.moveElementToIdx(heap[firstChildIdx], idx);
            idx = firstChildIdx;
            secondChildIdx = (firstChildIdx = idx << 1) + 1;
            if (!this.isElementIndexValid(secondChildIdx, heapSize) || !this.isElementPriorityLessThen(heap[secondChildIdx], heap[firstChildIdx])) continue;
            firstChildIdx = secondChildIdx;
        }
        this.moveElementToIdx(currentElement, idx);
    }

    private boolean isElementIndexValid(int elementIndex, int heapSize) {
        return elementIndex <= heapSize;
    }

    private boolean isElementPriorityLessThen(T a, T b) {
        return this.elementPriorityComparator.comparePriority(a, b) < 0;
    }

    private int increaseSizeByOne() {
        int minRequiredNewSize;
        int oldArraySize = this.queue.length;
        if ((minRequiredNewSize = ++this.size) >= oldArraySize) {
            int grow = oldArraySize < 64 ? oldArraySize + 2 : oldArraySize >> 1;
            this.resizeQueueArray(oldArraySize + grow, minRequiredNewSize);
        }
        return minRequiredNewSize;
    }

    public static interface HeapPriorityQueueElement {
        public static final int NOT_CONTAINED = Integer.MIN_VALUE;

        public int getInternalIndex();

        public void setInternalIndex(int var1);
    }

    public static interface PriorityComparator<T> {
        public int comparePriority(T var1, T var2);
    }
}

