/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessageSerializer;
import org.apache.flink.util.function.SerializableSupplier;

@Experimental
public class CommittableMessageTypeInfo<CommT>
extends TypeInformation<CommittableMessage<CommT>> {
    private final SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializerFactory;

    private CommittableMessageTypeInfo(SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializerFactory) {
        this.committableSerializerFactory = committableSerializerFactory;
    }

    public static <CommT> TypeInformation<CommittableMessage<CommT>> of(SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializerFactory) {
        return new CommittableMessageTypeInfo<CommT>(committableSerializerFactory);
    }

    public static TypeInformation<CommittableMessage<Void>> noOutput() {
        return new CommittableMessageTypeInfo<Void>((SerializableSupplier & Serializable)() -> new NoOutputSerializer());
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<CommittableMessage<CommT>> getTypeClass() {
        return CommittableMessage.class;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<CommittableMessage<CommT>> createSerializer(SerializerConfig config) {
        return new SimpleVersionedSerializerTypeSerializerProxy<CommittableMessage<CommT>>((SerializableSupplier & Serializable)() -> new CommittableMessageSerializer((SimpleVersionedSerializer)this.committableSerializerFactory.get())){

            public CommittableMessage<CommT> copy(CommittableMessage<CommT> from) {
                return from;
            }

            public CommittableMessage<CommT> copy(CommittableMessage<CommT> from, CommittableMessage<CommT> reuse) {
                return from;
            }
        };
    }

    public String toString() {
        return "CommittableMessageTypeInfo{serializer=" + this.committableSerializerFactory.get() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.canEqual(o)) {
            return false;
        }
        CommittableMessageTypeInfo that = (CommittableMessageTypeInfo)((Object)o);
        return Objects.equals(((SimpleVersionedSerializer)this.committableSerializerFactory.get()).getClass(), ((SimpleVersionedSerializer)that.committableSerializerFactory.get()).getClass());
    }

    public int hashCode() {
        return Objects.hash(((SimpleVersionedSerializer)this.committableSerializerFactory.get()).getClass());
    }

    public boolean canEqual(Object obj) {
        return obj instanceof CommittableMessageTypeInfo;
    }

    private static class NoOutputSerializer
    implements SimpleVersionedSerializer<Void> {
        private NoOutputSerializer() {
        }

        public int getVersion() {
            return 0;
        }

        public byte[] serialize(Void obj) {
            throw new IllegalStateException("Should not serialize anything");
        }

        public Void deserialize(int version, byte[] serialized) {
            throw new IllegalStateException("Should not deserialize anything");
        }
    }
}

